import Panel from "../MViews/MPanel";
import Net from "../Global/Net";
import PanelCtrl from "../MCtrls/MPanelCtrl";
import ToastPanel from "../MComponents/MToastPanel";
import GameMgr from "../Mgr/GameMgr";

export default class InputNumPanel extends Panel {
    get skinKey() { return "InputNumPanel" }
    public editor: eui.EditableText;
    public btnOk: eui.Button;
    public onPassed: () => void;

    onSkinComplete() {
        super.onSkinComplete();
        this.btnOk.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            let value = this.editor.text;
            if (new RegExp(/^[1][3,4,5,7,8][0-9]{9}$/).test(value)) {
                Net.sendPost(Net.uri.verifyNum, { //上传手机号
                    activityId: window["activityId"],
                    phone: value
                }, (res) => {
                    switch (res.data) {
                        case "0":
                            ToastPanel.show("号码未上传");
                            PanelCtrl.instance.show(ForbidPanel);
                            break;
                        case "1":
                            this.onPassed && this.onPassed();
                            break;
                        case "2":
                            PanelCtrl.instance.show(ForbidPanel);
                            break;
                    }
                });
                this.hidePanel();
            } else {
                ToastPanel.show('请输入正确的手机号');
            }
        }, this);
    }
}

export class ForbidPanel extends Panel {
    get skinKey() { return "ForbidPanel" }
}