import { MConfigs } from "../Global/MConfigs";

export default class GuideMask extends egret.DisplayObjectContainer {
    constructor(index: number, x: number, y: number) {
        super();
        const config = MConfigs.guide[index];


        let bg = new egret.Shape();
        bg.graphics.beginFill(0x000000);
        bg.graphics.drawRect(0, 0, 750, 1624);
        bg.graphics.endFill();
        bg.alpha = 0.7;

        let texture = RES.getRes(config.mask);
        let bitmap = new egret.Bitmap(texture);
        bitmap.x = x - texture.textureWidth / 2;
        bitmap.y = y - texture.textureHeight / 2;

        let container: egret.DisplayObjectContainer = new egret.DisplayObjectContainer();

        container.addChild(bg);
        container.addChild(bitmap);
        bitmap.blendMode = egret.BlendMode.ERASE;

        let renderTexture: egret.RenderTexture = new egret.RenderTexture();
        renderTexture.drawToTexture(container);
        let blendBitmap = new egret.Bitmap(renderTexture);
        this.addChild(blendBitmap);


        let offsetToMask = config.text.offsetToMask;
        let label = new eui.Label(config.text.str);
        label.size = 24;
        label.x = offsetToMask.x + bitmap.x;
        label.y = offsetToMask.y + bitmap.y;
        this.addChild(label);

        this.touchEnabled = true;
        this.onTap(this, () => {
            this.onClick && this.onClick();
        });
    }

    onClick: () => void;

    private setMask(texture: egret.Texture, x: number, y: number) {

    }

    private setText(text: string, offsetToMask: {
        x: number,
        y: number
    }) {

    }
}