import Panel from "../MViews/MPanel";
import MButton from "../MUI/MButton";

interface DataType {
    title: string,
    content: string,
    btnText: string,
    onClose?: () => void;
};

export default class CommonPanel extends Panel {
    get skinKey() { return "CommonPanel" }
    public btn: MButton;
    public labelTitle: eui.Label;
    public labelContent: eui.Label;
    public btnClose: MButton;

    data: DataType;

    init(data: DataType) {
        this.data = data;
    }

    onSkinComplete() {
        super.onSkinComplete();
        this.btnClose.onTap(this, () => {
            this.hidePanel();
            this.data.onClose && this.data.onClose();
        });
        this.labelTitle.text = this.data.title;
        this.labelContent.text = this.data.content;
        this.btn.label = this.data.btnText;
    }
}