// export const MConfigs: any = window;
export namespace MConfigs {
    export function updateConfig() {
        let mconfig = window["mconfig"];
        if (typeof mconfig != "object") return;

        Object.keys(mconfig).forEach(e => {
            MConfigs[e] = mconfig[e];
        });
    }

    export const size = [0.3125, 0.5357, 0.7321, 1];
    export const drop = {
        0: {
            type: "bullet",
            value: 1,
            textColor: 0x5dcefa,
            fileIndex: "0"
        },
        1: {
            type: "bullet",
            value: 2,
            textColor: 0x69e7fc,
            fileIndex: "1"
        },
        2: {
            type: "power",
            value: 30,
            textColor: 0xe83cf7,
            fileIndex: "2"
        },
        3: {
            type: "power",
            value: 20,
            textColor: 0xeb3924,
            fileIndex: "1"
        },
        4: {
            type: "power",
            value: 10,
            textColor: 0xfef552,
            fileIndex: "0"
        }
    }

    export const dropPool = {
        0: {
            num: 3,
            factor: {
                0: 40,
                1: 0,
                2: 0,
                3: 15,
                4: 50
            }
        },
        1: {
            num: 2,
            factor: {
                0: 40,
                1: 0,
                2: 5,
                3: 15,
                4: 50
            }
        },
        2: {
            num: 1,
            factor: {
                0: 40,
                1: 0,
                2: 5,
                3: 15,
                4: 50
            }
        }
    }

    export const props: {
        [key: string]: {
            id: string,
            type: 0 | 1
            value: number
        }
    } = {
        "sp_1": {
            id: "sp_1",
            type: 0,
            value: null
        },
        "sp_2": {
            id: "sp_2",
            type: 1,
            value: 10000
        },
        "sp_3": {
            id: "sp_3",
            type: 1,
            value: 20000
        },
        "sp_4": {
            id: "sp_4",
            type: 1,
            value: 30000
        },
        "sp_5": {
            id: "sp_5",
            type: 1,
            value: 60000
        },
        "sp_6": {
            id: "sp_6",
            type: 1,
            value: 80000
        }
    }

    export const boomEffectColor = [
        0xe41014,
        0xff9600,
        0x0090ff,
        0x8aff00,
        0xffe720
    ]

    /**倒计时秒数 */
    export const countDown = 300;

    /**毫秒 */
    export const GameOverPanelStayTime = 60000;

    export const rewardList = [

    ]

    export const guide: {
        [key: number]: {
            mask: string,
            text: {
                str: string,
                offsetToMask: {
                    x: number,
                    y: number
                }
            }
        }
    } = {
        0: {
            mask: "guide_mask_0_png",
            text: {
                str: "左右移动炮车进行射击和躲避",
                offsetToMask: {
                    x: 41,
                    y: 240
                }
            }
        },
        1: {
            mask: "guide_mask_1_png",
            text: {
                str: "拾取金币可获得更多的炮弹输出和得分加成",
                offsetToMask: {
                    x: 41,
                    y: 394
                }
            }
        },
    }

    export const difficultyFactor = 0.1;

    export const lastRankListOpenDate = "20191028";
    export const lastRankListType = "20191028";

    export const rewardRecordUrl = "http://activity.m.duibatest.com.cn/projectx/p98a3fa4c/f09ba186f.html";

    export const onlineDate = "2019-10-31 14:50:49:123";

    export const rule = "";

    export const shareUrl = "http://www.abchina.com/luascript/shareOnClick/%7B%22return%22%3A%7B%22share_title%22%3A%22%E8%80%81%E8%A1%A8%EF%BC%8C%E8%BF%99%E6%AC%BE%E6%B8%B8%E6%88%8F%E8%B4%BC%E5%A5%BD%E7%8E%A9%E5%84%BF%EF%BC%81%22%2C%22share_text%22%3A%22%E6%AF%8F%E5%A4%A9%E4%B8%8A%E5%86%9C%E8%A1%8CAPP%E7%8E%A9%E6%89%93%E6%98%9F%E7%90%83%EF%BC%8C%E8%B6%85%E5%A4%9A%E4%B8%B0%E5%AF%8C%E5%A5%96%E5%93%81%E7%AD%89%E4%BD%A0%E6%9D%A5%E6%8B%BF%EF%BC%81%22%2C%22share_url%22%3A%22http%3A%2F%2Factivity-3.m.duiba.com.cn%2FcustomShare%2Fshare%3Fid%3D3693%22%2C%22share_img_url%22%3A%22http%3A%2F%2Fduiba.oss-cn-hangzhou.aliyuncs.com%2Fdb_games%2Factivity%2Fdxq_jxnh%2Fshare.png%22%7D%7D";

    export const share = {
        title: "分享标题",
        desc: "分享描述",
        imgUrl: "http://duiba.oss-cn-hangzhou.aliyuncs.com/db_games/activity/zhaohang_bill_2019/share.png",
        url: "http://activity-2.m.duiba.com.cn/customShare/share?id=3651"
    }

    export const rankPrizes = [
        {
            text: "第1名",
            url: `prize_0_jpg`
        },
        {
            text: "第2-4名",
            url: `prize_1_jpg`
        },
        {
            text: "第5-7名",
            url: `prize_2_jpg`
        },
        {
            text: "第8-10名",
            url: `prize_3_jpg`
        }
    ];
}






