import GameObject from "./GameObject";

/**游戏物体组件基类 */
export default abstract class GameComponent {
    
    public get enabled(): boolean {
        return this._enabled;
    }
    public set enabled(v: boolean) {
        if (v == true && this._enabled == false) {
            this.onEnabled();
            this._enabled = v;
        } else if (v == false && this._enabled == true) {
            this.onDisabled();
            this._enabled = v;
        }
    }
    private _enabled: boolean = false;

    public get owner(): GameObject {
        return this._owner;
    }
    private _owner: GameObject = null;
    constructor(owner: GameObject) {
        this._owner = owner;
    }

    protected abstract onEnabled(): void;
    protected abstract onDisabled(): void;
}