import Panel from "../views/Panel";
import AchievementItem from "../item/AchievementItem";
import LayoutGroup, { LineLayoutGroupType } from "../components/LayoutGroup";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import { NetBuried } from "../NetBuried";

export default class AchievementPanel extends Panel {
    public get skinKey() { return "AchievementPanel" }

    public dataGroup: eui.DataGroup;

   

    onSkinComplete() {
        super.onSkinComplete();

       // NetBuried.ins.showLog(22)
        let data=DataManager.ins.getData(NetName.EVOLUTION_RECORD_KUWO).data

        let dataTo=[]
        for(let i=0;i<6;i++){
            if(data[i]){
                dataTo.push({
                    id: 2+i,
                    locked: false,
                    gmtCreate:data[i].gmtCreate
                })
            }else{
                dataTo.push({
                    id: 2+i,
                    locked: true,
                    gmtCreate:null
                })
            }
        }
        (this.dataGroup.dataProvider as eui.ArrayCollection).source = dataTo

        this.dataGroup.itemRenderer = AchievementItem;
    }

    envent_s

    initEvents(){
        super.initEvents()
        GDispatcher.addEvent("closeAchievement",this.onTouchTap,this)
    }

    removeEvents(){
        super.removeEvents()
        GDispatcher.removeEvent("closeAchievement",this.onTouchTap,this)
    }
}