import Panel from "../views/Panel";
import AchievementItem from "../item/AchievementItem";
import LayoutGroup, { LineLayoutGroupType } from "../components/LayoutGroup";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";

export default class AchievementPanel extends Panel {
    public get skinKey() { return "AchievementPanel" }

    public dataGroup: eui.DataGroup;

    envent

    initEvents(){
        super.initEvents()
        GDispatcher.addEvent("closeAchievement",this.envent=this.onTouchTap(),this)
    }

    removeEvents(){
        super.removeEvents()
        GDispatcher.removeEvent("closeAchievement",this.envent,this)
    }

    onSkinComplete() {
        super.onSkinComplete();

        (this.dataGroup.dataProvider as eui.ArrayCollection).source = [
            {
                id: 2,
                locked: false
            },
            {
                id: 3,
                locked: false
            },
            {
                id: 4,
                locked: false
            },
            {
                id: 5,
                locked: false
            },
            {
                id: 6,
                locked: false
            },
            {
                id: 7,
                locked: false
            }
        ];

        this.dataGroup.itemRenderer = AchievementItem;
    }
}