import Panel from "../views/Panel";
import AchievementItem from "../item/AchievementItem";
import LayoutGroup, { LineLayoutGroupType } from "../components/LayoutGroup";

export default class AchievementPanel extends Panel {
    public get skinKey() { return "AchievementPanel" }

    public dataGroup: eui.DataGroup;

    onSkinComplete() {
        super.onSkinComplete();

        (this.dataGroup.dataProvider as eui.ArrayCollection).source = [
            {
                id: 0,
                locked: false
            },
            {
                id: 1,
                locked: false
            },
            {
                id: 2,
                locked: true
            },
            {
                id: 3,
                locked: false
            },
            {
                id: 4,
                locked: true
            },
            {
                id: 5,
                locked: false
            }
        ];

        this.dataGroup.itemRenderer = AchievementItem;
    }
}