import { MUtils } from "../MUtils";
import MItem from "../components/MItem";
import { NetPromise } from "../NetPromise";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";

export default class ListenMusicItem extends MItem {
    public avatarGroup:eui.Group;
    public pic:eui.Image;
    public picMask:eui.Rect;
    public musicName:eui.Label;
    public singer:eui.Label;
    public btnOk:eui.Button;
    public lableMask:eui.Rect;
    public lableMask0:eui.Rect;    
    dataChanged() {
        this.musicName.text = this.data["musicName"];
        this.singer.text = this.data["singer"];
        this.pic.mask=this.picMask;
        this.musicName.mask=this.lableMask0;
        this.singer.mask=this.lableMask;
        this.pic.source = this.data["albumpic"];
        if(this.musicNameLoop){
            console.log(this.musicName.text)
            egret.Tween.removeTweens(this.musicName)
            this.musicName.x=103
            /* this.musicNameLoop = egret.Tween.get( this.musicName, { loop:true} );
            this.musicNameLoop.to( {x:103}, 10000 ).call( ()=>{
            }) */
        }
        if(this.musicName.width>this.lableMask.width){
            this.musicName.x=this.lableMask.x+this.lableMask.width;
            this.musicNameLoop = egret.Tween.get( this.musicName, { loop:true} );
            this.musicNameLoop.to( {x:-this.musicName.width}, 10000 ).call( ()=>{
            })
        }else{
            if(this.musicNameLoop){
                egret.Tween.removeTweens(this.musicName)
                this.musicName.x=103
                /* this.musicNameLoop = egret.Tween.get( this.musicName, { loop:true} );
                this.musicNameLoop.to( {x:103}, 10000 ).call( ()=>{
                }) */
            }
        }
    }
    musicNameLoop

    protected onSkinComplete() {
        this.btnOk.addEventListener(egret.TouchEvent.TOUCH_TAP, () => {
            this.enabled=false;
            console.log("收听歌曲：" + this.data["musicName"]);
            let _data=DataManager.ins.getData(NetName.FORFAVOR_KUWO).data
            NetPromise.ins.completeTaskKuwo(window["eduSignId"],3)
            .then(()=>{
                console.log("收听歌曲")
                PanelCtrl.instance.show(ModuleTypes.REWARD_PANEL, {
                    title: `完成收听歌曲`,
                    rewardNum: DataManager.ins.getData(NetName.COMPLETE_TASK_KUWO).data.response.changeMoney ? DataManager.ins.getData(NetName.COMPLETE_TASK_KUWO).data.response.changeMoney : 0
                });
                this.enabled=true;
            })
            .catch(()=>{
                this.enabled=true;
            })

            NetPromise.ins.handlePlay({
                album: _data[this.data["index"]].album,
                artist: _data[this.data["index"]].artist,
                formats: _data[this.data["index"]].formats,
                fsongname: "",
                hasmv: false,
                isdownload: "0",
                kmark: "",
                musicrid: _data[this.data["index"]].musicrid,
                name: _data[this.data["index"]].name,
                nationid: _data[this.data["index"]].nationid,
                online: _data[this.data["index"]].online,
                pay:  _data[this.data["index"]].pay,
                psrc: "h5app_worldcup"
            })
        }, this);
    }
}