import { MUtils } from "../MUtils";
import MItem from "../components/MItem";
import { NetPromise } from "../NetPromise";
import PanelCtrl from "../ctrls/panelCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";

export default class FavoriteMusicItem extends MItem {
    public avatarGroup:eui.Group;
    public pic:eui.Image;
    public picMask:eui.Rect;
    public musicName:eui.Label;
    public singer:eui.Label;
    public btnFavorite:eui.Button;
    public labelFavorite:eui.Label;
    public lableMask:eui.Rect;



    private readonly favoriteColor: number = 0xfbc1c5;
    private readonly noFavoriteColor: number = 0xfdfefe;

    protected onSkinComplete() {
        this.btnFavorite.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickFavorite, this);
        this.labelFavorite.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onClickFavorite, this);
    }

    nameX=103;
    musicNameLoop;

    dataChanged() {
        this.musicName.text = this.data["musicName"];
        this.singer.text = this.data["singer"];
        this.pic.source = this.data["albumpic"];
        this.pic.mask=this.picMask;
        this.singer.mask=this.lableMask;
        this.musicName.mask=this["lableMask0"];
        this.setFavorite();
    }

    private onClickFavorite() {
        this.data["favorite"] = !this.data["favorite"];
       // this.enabled=false;
        this.setFavorite2();
    }

    private async setFavorite2() {
        this.labelFavorite.textColor = this.favoriteColor;
        MUtils.setButtonImage(this.btnFavorite, await RES.getResAsync("favorite_music_favorite_png"));
        NetPromise.ins.completeTaskKuwo(window["eduSignId"],2)
        .then(()=>{
            console.log("收藏成功")
            PanelCtrl.instance.show(ModuleTypes.REWARD_PANEL, {
                title: `完成收藏歌曲`,
                rewardNum: DataManager.ins.getData(NetName.COMPLETE_TASK_KUWO).data.response.changeMoney ? DataManager.ins.getData(NetName.COMPLETE_TASK_KUWO).data.response.changeMoney : 0
            });
            //this.enabled=false;
        })
        .catch(()=>{
            this.enabled=true;
        })

        NetPromise.ins.likeSong(window["loginUid"],window["sid"],this.data["musicrid"])
        .then(()=>{
           
        })
        .catch(()=>{
           // this.enabled=true;
        })
    }

    private async setFavorite() {
        if (this.data["favorite"]) {
            this.labelFavorite.textColor = this.favoriteColor;
            MUtils.setButtonImage(this.btnFavorite, await RES.getResAsync("favorite_music_favorite_png"));
        } else {
            this.labelFavorite.textColor = this.noFavoriteColor;
            MUtils.setButtonImage(this.btnFavorite, await RES.getResAsync("favorite_music_no_favorite_png"));
        }

       /*  if(this.musicName.width>this.lableMask.width){
            this.musicName.x=this.lableMask.x+this.lableMask.width;
            this.musicNameLoop = egret.Tween.get( this.musicName, { loop:true} );
            this.musicNameLoop.to( {x:-this.musicName.width}, 10000 ).call( ()=>{
            })
        } */
    }
}