import MItem from "../components/MItem";
import { MConfigs } from "../MConfigs";

export default class AchievementPicItem extends eui.Component {
    public light: eui.Image;
    public pic: eui.Image;
    public achievementName: eui.Label;
    private id = 0;

    constructor(id) {
        super();
        this.id = id-2;
        this.addEventListener(egret.Event.ADDED_TO_STAGE, async () => {
            await this.preLoad();
            this.skinName = "AchievementPicItem";
            this.onSkinComplete();
        }, this);
    }

    protected async preLoad() {
        await RES.loadGroup("achievement_pic_item");
    }

    protected async onSkinComplete() {
        let configData = MConfigs.achievement[this.id];
        this.achievementName.text = configData["name"];
        this.pic.texture = RES.getRes(`achievement_item_pic${configData["id"]}_png`);
        this.playLightEffect();
    }

    private playLightEffect() {
        let callback = () => {
            egret.Tween.get(this.light).to({ rotation: 360 }, 7000).call(callback);
        }
        callback();

        let timer = new egret.Timer(300, 1);
        timer.addEventListener(egret.TimerEvent.TIMER_COMPLETE, () => {
            egret.Tween.get(this.light).to({ alpha: 1 }, 200);
        }, this);
        timer.start();
        this.addEventListener(egret.Event.REMOVED_FROM_STAGE, () => {
            timer.stop();
        }, this);
    }
}