import Panel from "../views/Panel";
import ScoreItem from "../item/ScoreItem";
import DefaultCallback from "../Decorator/DefaultCallback";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";

@DefaultCallback
export default class ScorePanel extends Panel {
    public get skinKey() { return "ScorePanel" }
    public get groupName() { return "score_panel" }

    public bodyScroller:eui.Scroller;
    public list:eui.List;
    public closeBtn:eui.Button;
    

    onSkinComplete() {
        super.onSkinComplete();
        let dataA = DataManager.ins.getData(NetName.KUWO_MUSIC_SCORE).data;
        console.log(dataA)
        let data = [];
        for (let i = 0; i < dataA.length; i++) {
            let _data= JSON.parse(dataA[i].musicJson)
            data.push({
                musicName: _data.name,
                singer: _data.artist,
                pic:_data.pic,
                favorite: true
            });
        }
        this.list.dataProvider = new eui.ArrayCollection(data);
        this.list.itemRenderer = ScoreItem;
    }
}

