import Panel from "../views/Panel";
import ScoreItem from "../item/ScoreItem";
import DefaultCallback from "../Decorator/DefaultCallback";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";

@DefaultCallback
export default class ScorePanel extends Panel {
    public get skinKey() { return "ScorePanel" }
    public get groupName() { return "score_panel" }

    public list: eui.List;
    public closeBtn: eui.Button;

    onSkinComplete() {
        super.onSkinComplete();
        let data = DataManager.ins.getData(NetName.KUWO_MUSIC_SCORE).data;
        for (let i = 0; i <= 100; i++) {
            data.push({
                musicName: "缺氧",
                singer: "杨丞琳",
                favorite: true
            });
        }
        this.list.dataProvider = new eui.ArrayCollection(data);
        this.list.itemRenderer = ScoreItem;
    }
}

