import Panel from "../views/Panel";
import FavoriteMusicItem from "../item/FavoriteMusicItem";
import LineLayoutGroup from "../components/LayoutGroup";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetName } from "../../libs/tw/enum/NetName";
import { NetBuried } from "../NetBuried";

export default class FavoriteMusicPanel extends Panel {
    public get skinKey() { return "FavoriteMusicPanel" }
    public get groupName() { return "favorite_music_panel" }

    public scroller: eui.Scroller;
    public scrollerGroup: eui.Group;
    public list: eui.List;

    onSkinComplete() {
        super.onSkinComplete();

        NetBuried.ins.showLog(24)
       /*  let dataProvider = this.list.dataProvider as eui.ArrayCollection;
        dataProvider.source = []; */
        let data2=[]

        

        console.log(DataManager.ins.getData(NetName.FORFAVOR_KUWO))

        let lists=DataManager.ins.getData(NetName.FORFAVOR_KUWO).data;

        lists.forEach(list => {
            data2.push({
                musicName: list.name,
                singer: list.artist,
                albumpic: list.albumpic,
                musicrid: list.musicrid,
                favorite: false
            });
        });

        this.list.dataProvider = new eui.ArrayCollection(data2);
        this.list.itemRenderer = FavoriteMusicItem;
    }
}