import PanelCtrl from "./ctrls/panelCtrl";
import { ModuleTypes } from "./types/sceneTypes";
import { NetName } from "../libs/tw/enum/NetName";
import { NetPromise } from "./NetPromise";
import { DataManager } from "../libs/tw/manager/DataManager";

export namespace MConfigs {
    export let achievement = {
        1: { id: "0", name: "路人甲", },
        2: { id: "0", name: "练习生" },
        3: { id: "1", name: "扛琴小弟" },
        4: { id: "2", name: "乐队主唱" },
        5: { id: "3", name: "酒吧驻唱" },
        6: { id: "4", name: "签约艺人" },
        7: { id: "5", name: "偶像巨星" }
    }

    export let quest = {
        0: {
            id: "0",
            name: "首次到访",
            reward: "零花钱+10金币",
            maxTime: null,
            todo: () => {
                console.log("去完成首次到访");
            }
        },
        1: {
            id: "1",
            name: "个人中心签到",
            reward: "零花钱+10金币",
            maxTime: null,
            todo: () => {
                console.log("去完成个人中心签到");
                NetPromise.ins.completeTaskKuwo(window["eduSignId"], 1)
                    .then(() => {
                        localStorage.setItem("signGold", DataManager.ins.getData(NetName.COMPLETE_TASK_KUWO).data.response.changeMoney ? DataManager.ins.getData(NetName.COMPLETE_TASK_KUWO).data.response.changeMoney : 0)
                        window.location.href = "https://m.kuwo.cn/newh5/score/index"
                    })
            },
        },
        2: {
            id: "2",
            name: "每日分享",
            reward: "零花钱+20金币",
            maxTime: null,
            todo: () => {
                console.log("去完成每日分享");
                NetPromise.ins.handleShare()
                    .then(() => {
                        return NetPromise.ins.completeTaskKuwo(window["eduSignId"], 4)
                    })
                    .then(() => {
                        console.log("分享成功")
                        PanelCtrl.instance.show(ModuleTypes.REWARD_PANEL, {
                            title: `分享成功`,
                            rewardNum: DataManager.ins.getData(NetName.COMPLETE_TASK_KUWO).data.response.changeMoney ? DataManager.ins.getData(NetName.COMPLETE_TASK_KUWO).data.response.changeMoney : 0
                        });
                    })
            },
        },
        3: {
            id: "3",
            name: "收藏歌曲",
            reward: "零花钱+20金币",
            maxTime: 3,
            todo: () => {
                NetPromise.ins.forFavor(window["loginUid"], window["sid"])
                    .then(() => {
                        PanelCtrl.instance.show(ModuleTypes.FAVORITE_MUSIC_PANEL);
                    })
            },
        },
        4: {
            id: "4",
            name: "收听歌曲",
            reward: "零花钱+20金币",
            maxTime: null,
            todo: () => {
                NetPromise.ins.forFavor(window["loginUid"], window["sid"])
                    .then(() => {
                        PanelCtrl.instance.show(ModuleTypes.LISTEN_MUSIC_PANEL);
                    })
            }
        }
    }

    export let msgsAuto = [
        "你是碳酸饮料吧？让我一见到就开心冒泡。",
        "我要的不多，只要你。我有的不多，全给你。",
        "我不属于十二星座，只是为你量身定做。",
        "没有甜品的时候，小酷只好想想你了。",
        "我是可爱的小酷，你是可爱。",
        "今天不吃大碗宽面，只想住你心里面。",
        "只许州官放火，不许你离开我。",
        "你点开了我，我想点开你的心。",
        "我一点也不想你，一点半再想。",
        "小酷请你吃种梨，酷我黑风梨。"
    ]
}