export class AddScore extends eui.Component{
    public addScoreText:eui.Label;
    private callBack:Function;
    private currLjLb:eui.Label;

    constructor(callBack:Function = null){
        super();
        this.skinName       = 'resource/skins/ui/AddScoreSkin.exml';

        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
        
        this.callBack = callBack;
    }

    private onSkinComplete():void{

        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);

    }

    public set score(s:number){
        this.addScoreText.text = '亚运分+' + s;
    }

    public set aframe(idx:number){
        for(let i = 1; i < 10; i++){
            this['group' + i].visible = idx == i ? true : false;
        }

        if(idx == 3 || idx == 6 || idx == 9){
            this.currLjLb = this['ljLb' + idx];
        }
    }

    public set ljNum(num:number){
        this.currLjLb.text = '连击X' + num;
    }

    public removeEvent():void{
    }

}