import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
import { NetName } from '../../libs/tw/enum/NetName';
import { GCache } from '../../libs/tc/util/GCache';
export default class StartScene1 extends Scene {
    public ruleBtn:eui.Button;
    public prizeBtn:eui.Button;
    public startBtn:eui.Button;
    public rankBtn:eui.Button;
    public propBtn:eui.Button;
    public energyBtn:eui.Button;
    public shengmingLb:eui.Label;

    public freeTimeLb:eui.Label;

    public mainbg:eui.Image;

    public sData:any;

    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);
        this.sData = data;

    }

    initEvents() {
        super.initEvents();
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.startBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        this.propBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_propBtn, this);
        this.energyBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_energyBtn, this);
        this.rankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
    }

    removeEvents() {
        super.removeEvents();

        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.startBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_startBtn, this);
        this.propBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_propBtn, this);
        this.rankBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this);
        this.energyBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_energyBtn, this);
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        this.bgtexture = await RES.getResAsync('startBg_jpg');
        await RES.loadGroup('common');
        // console.log('载背景并设置背景图片mainscene');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad(): void {

        let data = DataManager.ins.getData(NetName.GET_INDEX).data;

        if(data.remainTime > 0){
            this.freeTimeLb.text = '今日还可以进行' + data.remainTime + '次';
        }else{
            this.freeTimeLb.text = '今日次数已用完，明天再来吧';
        }


        if(data.hasReward){
            Loading.instace.show();
            NetManager.ins.getProjectUserInfo((success)=>{
                Loading.instace.hide();
                if(success){
                    GCache.init([window['appid'] + '', Buried.oaId + '', DataManager.ins.getData(NetName.GET_PROJECT_USER_INFO).data.consumerId + '']);

                    let date = new Date(data.sendPrizeTime);
                    let timeStr = date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();

                    const isPrize = GCache.readCache('isPrize' + timeStr);
                    if(!isPrize){
                        GCache.writeCache('isPrize' + timeStr, 'true');
                        PanelCtrl.instance.show(ModuleTypes.RANK_PRIZE_PANEL);
                    }
                }else{
                    //应该静默处理
                }
            });
        }
        this.initUI();
    }

    private initUI():void{

        PanelCtrl.instance.isLoseCoin = false;
        egret.Tween.get(this.startBtn, {loop:true})
            .to({scaleX:1.05, scaleY:1.05}, 150)
            .to({scaleX:0.9, scaleY:0.9}, 150)
            .to({scaleX:1.05, scaleY:1.05}, 150)
            .to({scaleX:0.9, scaleY:0.9}, 150).wait(500);
        

        var u = navigator.userAgent;//, app = navigator.appVersion;
        var android = u.indexOf('Android') > -1 || u.indexOf('Linux') > -1; //g
        var iphone = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端
        // var android = window['ua'].match(/(Android);?[\s\/]+([\d.]+)?/); // 判断是否安卓
        // var iphone = !window['ipad'] && window['ua'].match(/(iPhone\sOS)\s([\d_]+)/); // 判断iOS

        if(iphone){
            this.shengmingLb.visible = true;
        }

        if(android){
            this.shengmingLb.visible = false;
        }

    }

    private onTap_ruleBtn():void{

        console.log('点击rule');
        PanelCtrl.instance.btnDelay(this.ruleBtn);
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL); 
    }

    private onTap_startBtn():void{
        PanelCtrl.instance.btnDelay(this.startBtn);
        let data = DataManager.ins.getData(NetName.GET_INDEX).data;
        if(data.remainTime < 1){
            TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '今日次数已用完，明天再来吧~' });
            return;
        }

        NetManager.ins.doStart((success:boolean)=>{
            let data = DataManager.ins.getData(NetName.DO_START);
            if(!success){
                if(data && data.code == '100001'){
                    TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '今日次数已用完，明天再来吧~' });
                }else{
                    TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '啊哦，网络开小差了~' });
                }
            }else{
                SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
            }
        });

        
    }

    private onTap_rankBtn():void{
        console.log('点击rankBtn');

        PanelCtrl.instance.btnDelay(this.rankBtn);
        
        let data = DataManager.ins.getData(NetName.GET_INDEX).data;
        NetManager.ins.getRanking((success)=>{
            if(success){
                PanelCtrl.instance.show(ModuleTypes.RANK_PANEL);
            }else{
                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '啊哦，网络开小差了~' });
            }
        }, data.rankType, 10);
    }

    private onTap_energyBtn():void{
        console.log('点击能量')
        PanelCtrl.instance.btnDelay(this.energyBtn);
        NetManager.ins.getRecords((success)=>{
            if(success){
                let data = DataManager.ins.getData(NetName.GET_RECORD_ENERGY);
                console.log('data', data);
                PanelCtrl.instance.show(ModuleTypes.ENERGY_PANEL);
            }else{
                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '啊哦，网络开小差了~' });
            }
        });
    }

    private onTap_propBtn():void{
        console.log('点击prizeBtn'); 
        PanelCtrl.instance.btnDelay(this.prizeBtn);
        PanelCtrl.instance.show(ModuleTypes.PROP_PANEL);
    }
    

}
