import { HtmlTextParser } from '../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
import { NetName } from '../../libs/tw/enum/NetName';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
export default class UsePropPanel extends Panel {
    public closeBtn: eui.Button;

    public cardGroup:eui.Group;
    public card0:eui.Image;
    public card1:eui.Image;
    public timeLb:eui.Label;
    public countLb:eui.Label;

    private mdata:any;

    public get skinKey() { return 'UsePropPanel' }
    public get groupName() { return 'useprop_panel' }

    constructor(data: any) {
        super(data);
        this.mdata = data;
    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.cardGroup.addEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.cardGroup.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.ontap, this);
    }

    private idx:number;
    private onLoad(): void {
        this.card0.visible = true;
        this.card1.visible = false;

        let tcount = 3;
        this.timeLb.text = tcount + '';
        this.idx = setInterval(()=>{
            tcount--;
            if(tcount < 1){
                clearInterval(this.idx);
                this.submit(false);
            }else{
                this.timeLb.text = tcount + '';
            }

        }, 1000);
        let data = DataManager.ins.getData(NetName.GET_INDEX).data;
        this.countLb.text = data.cardCount;
    }

    private ontap():void{
        PanelCtrl.instance.btnDelay(this.cardGroup);
        this.cardGroup.touchEnabled = false;
        this.cardGroup.touchChildren = false;
        clearInterval(this.idx);
        this.submit(true);

        this.card0.visible = !this.card0.visible;
        this.card1.visible = !this.card1.visible;
    }

    

    private submit(isUse:boolean):void{
        let data = DataManager.ins.getData(NetName.DO_START).data;
        NetManager.ins.doSubmit((success)=>{
            if(success){
                PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL);
            }else{
                let data = DataManager.ins.getData(NetName.DO_SUBMIT);
                if(data){
                    if(data.code){
                        if(data.code == '100102'){//生成签名异常
                            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, '数据异常');
                        }else if(data.code == '100103'){//签名错误
                            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, '数据异常');
                        }else if(data.code == '100101'){//游戏分数异常
                            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, '您本局的游戏数据存在异常，请遵守游戏规则哟');
                        }else{
                            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, '啊哦，网络开小差了~');
                        }
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, '啊哦，网络开小差了~');
                    }
                }else{
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, '啊哦，网络开小差了~');
                }

            }
        }, data.recordId, this.mdata, NetManager.ins.createSgin1(data.recordId, this.mdata, isUse, data.token), isUse);
    }

}