import { HtmlTextParser } from '../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
import { NetName } from '../../libs/tw/enum/NetName';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
export default class RankPrizePanel extends Panel {
    public closeBtn: eui.Button;

    public rankLb: eui.Label;
    public prizeLb:eui.Label;
    public okBtn:eui.Button;

    public get skinKey() { return 'RankPrizePanel' }
    public get groupName() { return 'rankprize_panel' }

    constructor(data: any) {
        super(data);

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_okBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_okBtn, this);
    }

    private onLoad(): void {
        let data = DataManager.ins.getData(NetName.GET_INDEX).data;
        // let date = new Date(data.sendPrizeTime);
        // let timeStr = date.getFullYear() + "-" + (date.getMonth() + 1) + "-" + date.getDate();
        this.rankLb.textFlow = [
            {text: "上次排名第", style: {"size": 33}},
            {text: data.rank, style: {"textColor": 0xfcb600, "size": 50, "italic":true}},
            {text: "名", style: {"size": 33}}
        ];
        this.prizeLb.text = '';
        if(data.prizeId){
            NetManager.ins.getPrizeDetail((success)=>{
                if(success){
                    let pdata = DataManager.ins.getData(NetName.GET_PRIZE_DETAIL).data;
                    if(pdata.length > 0){
                        pdata = pdata[0];
                    }
                    this.prizeLb.text = '获得' + pdata.name;
                    this.prizeLb.visible = true;
                }else{
                    this.prizeLb.visible = false;
                }
            }, data.prizeId);

        }else{
            this.prizeLb.text = '';
            this.prizeLb.visible = false;

        }
    }

    private onTap_okBtn():void{
        console.log('点击sharebtn');
        PanelCtrl.instance.btnDelay(this.okBtn);
        this.onTouchTap();
    }


}