import { HtmlTextParser } from '../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
import { NetName } from '../../libs/tw/enum/NetName';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
export default class RankPanel extends Panel {
    public closeBtn: eui.Button;
    public rankGroup:eui.Group;
    public myRankLb:eui.Label;
    public myScoreLb:eui.Label;

    public get skinKey() { return 'RankPanel' }
    public get groupName() { return 'rank_panel' }

    constructor(data: any) {
        super(data);

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
    }

    removeEvents(): void {
        super.removeEvents();
    }

    private onLoad(): void {
        
        let mdata = DataManager.ins.getData(NetName.GET_INDEX).data;
        if(mdata.myTodayRank > 10 || !mdata.myTodayRank){
            this.myRankLb.text = '未上榜';
        }else{
            this.myRankLb.text = mdata.myTodayRank;
        }

        this.myScoreLb.text = mdata.myTodayScore + 0;

        //排行信息
        let data = DataManager.ins.getData(NetName.GET_RANKING).data;
        if(!data) return;

        let idxStr;
        for(let i = 0; i < data.length; i++){
            let idata = data[i];
            if(i == 0){
                idxStr = idata.userId;
            }else{
                idxStr += ',' + idata.userId;
            }
        }

        let hasPhone;
        NetManager.ins.batchQueryUserInfo((success:boolean)=>{
            if(success){
                hasPhone = true;
            }else{
                hasPhone = false;
            }
            let data1 = DataManager.ins.getData(NetName.BATCH_QUERY_USERINFO).data;

            for(let i = 0; i < data.length; i++){
                let idata = data[i];
    
                let g = new eui.Group();
                g.percentWidth = 100;
                g.height = 66;
                g.y = i * 66;
    
    
                let rankLb = new eui.Label();
                rankLb.x = 3;
                rankLb.y = 18;
                rankLb.text = idata.index;
                rankLb.size = 30;
                rankLb.width = 100;
                rankLb.textAlign = egret.HorizontalAlign.CENTER;
                g.addChild(rankLb);
    
                let phoneLb = new eui.Label();
                phoneLb.x = 166;
                phoneLb.y = 18;
                phoneLb.width = 216;
                phoneLb.textAlign = egret.HorizontalAlign.CENTER;
                phoneLb.text = idata.userId;
                phoneLb.size = 30;
                g.addChild(phoneLb);

                if(data1){
                    if(hasPhone && data1[i] && data1[i].phone){
                        var phone:string = data1[i].phone + '';
                        phoneLb.text = phone.substr(0, 3) + '****' + phone.substr(7, 11);
                    }
                }
    
    
                let scoreLb = new eui.Label();
                scoreLb.x = 396;
                scoreLb.y = 18;
                scoreLb.width = 216;
                scoreLb.textAlign = egret.HorizontalAlign.CENTER;
                scoreLb.text = idata.score;
                scoreLb.size = 30;
                g.addChild(scoreLb);
    
                this.rankGroup.addChild(g);
    
            }
        },idxStr);

        
    }


}