import { HtmlTextParser } from '../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
import { NetName } from '../../libs/tw/enum/NetName';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
import Loading from '../loading/Loading';
export default class PropPanel extends Panel {
    public closeBtn: eui.Button;

    public countLb: eui.Label;
    public cardDis: eui.Image;
    public shareBtn:eui.Button;
    public card:eui.Image;

    public get skinKey() { return 'PropPanel' }
    public get groupName() { return 'prop_panel' }

    constructor(data: any) {
        super(data);

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
    }

    removeEvents(): void {
        super.removeEvents();
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
    }

    private onLoad(): void {
        let data = DataManager.ins.getData(NetName.GET_INDEX).data;
        if(data.cardCount > 0){
            this.countLb.text = data.cardCount;
            this.card.visible = true;
            this.countLb.visible = true;
            this.cardDis.visible = false;
        }else{
            this.card.visible = false;
            this.countLb.visible = false;
            this.cardDis.visible = true;
        }
    }

    private onTap_shareBtn():void{
        console.log('点击sharebtn');
        PanelCtrl.instance.btnDelay(this.shareBtn);
        if(window['AlipayJSBridge']){
            window['AlipayJSBridge'].call('esportsShare', {
                title:'亚运大灌篮，等你来挑战',
                content:'参与亚运大灌篮活动，有机会成为亚运火炬手',
                imgUrl:'https://yun.duiba.com.cn/db_games/activity/shareImg/20191028/shareImg.png',
                url: 'http://yazuwei.activity-1.m.duiba.com.cn/customShare/share?id=3602',
                type:'3'
            });
        }

        let indexData = DataManager.ins.getData(NetName.GET_INDEX).data;
        if(indexData.hasGiveCard){
            // setTimeout(() => {
            //     TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '分享成功' });
            // }, 2000);
        }else{

            Loading.instace.show();
            setTimeout(() => {
                NetManager.ins.addTimeShare((success:boolean)=>{
                    if(success){
                        var idata = DataManager.ins.getData(NetName.GET_INDEX).data;
                        let data = DataManager.ins.getData(NetName.ADDTIME_SHARE).data;
                        idata.hasGiveCard = true;
                        idata.cardCount = data;
    
                        this.countLb.text = data;
    
                        if(data > 0){
                            this.card.visible = true;
                            this.countLb.visible = true;
                            this.cardDis.visible = false;
                        }

                        // TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '已获得1张翻倍卡' });
                    }else{
                        //分享失败
                    }
                    Loading.instace.hide();
                });
            }, 2000);
        }



    }


}