import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
import { NetName } from '../../libs/tw/enum/NetName';
import SceneCtrl from '../ctrls/sceneCtrl';
import Loading from '../loading/Loading';
export default class GameOverPanel extends Panel {
    public closeBtn: eui.Button;
    public knowBtn: eui.Button;
    public rankBtn:eui.Button;
    public prizeLb:eui.Label;
    public shareBtn: eui.Button;

    public scoreLb:eui.Label;
    public maxScLb:eui.Label;
    public rankLb:eui.Label;

    private type:any;

    public get skinKey() { return 'GameOverPanel' }
    public get groupName() { return 'gameover_panel' }

    constructor(data: any) {
        super(data);
        this.type = data;

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.knowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this);
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);

        this.rankBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this)
    }

    removeEvents(): void {
        super.removeEvents();
        this.knowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this)
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this)

        this.rankBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_rankBtn, this)
    }
    onTap_knowBtn() {
        PanelCtrl.instance.btnDelay(this.knowBtn);
        
        //关闭弹框
        this.onTouchTap();
    }

    private onTap_shareBtn():void{
        PanelCtrl.instance.btnDelay(this.shareBtn);
        this.share();
    }
    private share():void{
        if(window['AlipayJSBridge']){
            window['AlipayJSBridge'].call('esportsShare', {
                title:'亚运大灌篮，等你来挑战',
                content:'参与亚运大灌篮活动，有机会成为亚运火炬手',
                imgUrl:'https://yun.duiba.com.cn/db_games/activity/shareImg/20191028/shareImg.png',
                url: 'http://yazuwei.activity-1.m.duiba.com.cn/customShare/share?id=3602',
                type:'3'
            });
        }

        let indexData = DataManager.ins.getData(NetName.GET_INDEX).data;
        if(indexData.hasGiveCard){
            // setTimeout(() => {
            //     TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '分享成功' });
            // }, 2000);
        }else{

            Loading.instace.show();
            setTimeout(() => {
                NetManager.ins.addTimeShare((success:boolean)=>{
                    if(success){
                        var idata = DataManager.ins.getData(NetName.GET_INDEX).data;
                        let data = DataManager.ins.getData(NetName.ADDTIME_SHARE).data;
                        idata.cardCount = data;
                        idata.hasGiveCard = true;

                        // TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '已获得1张翻倍卡' });
                    }else{
                        //分享失败
                    }
                    Loading.instace.hide();
                });
            }, 2000);
        }
    }

    public onTap_rankBtn():void{
        PanelCtrl.instance.btnDelay(this.rankBtn);

        NetManager.ins.getIndex((success) => {
            if (success) {
                let data = DataManager.ins.getData(NetName.GET_INDEX).data;
                NetManager.ins.getRanking((success)=>{
                    if(success){
                        TopLayerCtrl.instance.show(ModuleTypes.RANK_PANEL);
                    }else{
                        //失败
                        TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '啊哦，网络开小差了~' });
                    }
                }, data.rankType, 10);
            } else {
                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '啊哦，网络开小差了~' });

            }

        });

    }

    public onTouchTap():void{
        super.onTouchTap();

        this.goStart();
    }

    private onLoad(): void {
        this.prizeLb.visible = false;

        let data = DataManager.ins.getData(NetName.DO_SUBMIT).data;
        this.scoreLb.text = data.currentScore;
        this.maxScLb.text = data.highestScore;
        if(!data.rank || data.rank > 10){
            this.rankLb.text = '未上榜';
        }else{
            this.rankLb.text = data.rank;
        }

        if(data.prizeId){
            NetManager.ins.getPrizeDetail((success)=>{
                if(success){
                    let pdata = DataManager.ins.getData(NetName.GET_PRIZE_DETAIL).data;
                    if(pdata.length > 0){
                        pdata = pdata[0];
                    }
                    this.prizeLb.text = '获得' + pdata.name;
                    this.prizeLb.visible = true;
                }else{
                    this.prizeLb.visible = false;
                }
            }, data.prizeId);

        }else{
            this.prizeLb.text = '';
            this.prizeLb.visible = false;
        }
    }

    private goStart():void{
        NetManager.ins.getIndex((success) => {
            if (success) {

                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            } else {
                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '活动太火爆了，请稍后重试~' });
                return;

            }
        });
    }


}