import { HtmlTextParser } from '../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
import { NetName } from '../../libs/tw/enum/NetName';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
export default class EnergyPanel extends Panel {
    public closeBtn: eui.Button;
    public energyGroup:eui.Group;

    public get skinKey() { return 'EnergyPanel' }
    public get groupName() { return 'energy_panel' }

    constructor(data: any) {
        super(data);

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
    }

    removeEvents(): void {
        super.removeEvents();
    }

    private onLoad(): void {
        let data = DataManager.ins.getData(NetName.GET_RECORD_ENERGY).data;
        if(!data) return;

        let len = 0;
        if(data.length > 200){
            len = 200;
        }else{
            len = data.length;
        }
        for(let i = 0; i < len; i++){
            let idata = data[i];

            let g = new eui.Group();
            g.percentWidth = 100;
            g.height = 98;
            g.y = i * 98;

            let img = new eui.Image();
            img.y = 20;
            img.x = 62;
            img.source = 'icon_en_png';
            g.addChild(img);

            let nameLb = new eui.Label();
            nameLb.x = 196 + 50;
            nameLb.y = 26;
            nameLb.text = idata.extra.name;
            nameLb.stroke = 2;
            nameLb.size = 29;
            g.addChild(nameLb);


            let timeLb = new eui.Label();
            timeLb.x = 196 + 50;
            timeLb.y = 61;
            const date = new Date(idata.gmtCreate);
            timeLb.text = date.getFullYear() + '-' + (date.getMonth() + 1) + '-' + date.getDate() + ' ' + ((date.getHours() > 9 ? date.getHours() : ('0' + date.getHours()))) + ':' + ((date.getMinutes() > 9 ? date.getMinutes() : ('0' + date.getMinutes()))) + ':' + (date.getSeconds() > 9 ? date.getSeconds() : ('0' + date.getSeconds()));;
            timeLb.stroke = 2;
            timeLb.size = 20;
            g.addChild(timeLb);

            this.energyGroup.addChild(g);

        }
    }


}