
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";
import TopLayerCtrl from "../ctrls/topLayerCtrl";

export default class MsgPanel extends Panel {
    public okBtn:eui.Button;
    public msgLb:eui.Label;
    private mData:any;


    public get skinKey() { return 'MsgPanel' }
	public get groupName() { return 'msg_panel'}
    
    constructor(data?:IMsgData){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onLoad():void{

        if(this.mData){
            this.msgLb.text = this.mData;
        }

        
    }

    private onTap():void{
        PanelCtrl.instance.btnDelay(this.okBtn);
        this.onTouchTap();
    }

    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }
        this.goStart();

    }

    private goStart():void{
        NetManager.ins.getIndex((success) => {
            if (success) {

                SceneCtrl.instance.change(ModuleTypes.START_SCENE);
            } else {
                TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, { msg: '活动太火爆了，请稍后重试~' });
                return;

            }
        });
    }

}

export interface IMsgData{
    btnName:string,
    titleIdx:number,
    msg?:string,
    msg0?:string,
    callBack?:Function,
    closeCallBack?:Function 
}