import { DataManager } from '../../libs/tw/manager/DataManager';
import { ModuleTypes } from '../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import { VideoEntity } from '../../libs/SVGA';
import SceneCtrl from '../ctrls/sceneCtrl';
import { playSound, stopAllSound } from '../ctrls/soundCtrl';
import StartScene1 from '../startScene/StartScene';
import { GDispatcher } from '../../libs/tc/util/GDispatcher';
import ProgressBarS from './ProgressBarS';
export default class LoadingScene extends Scene {
    perTxt: eui.Label;
    loadingMark: eui.Image;


    progressBar: ProgressBarS

    public get skinKey() { return 'LoadingScene' }
    public get groupName() { return 'loadingscene' }

    constructor(data?) {
        super(data);

    }

    initEvents() {
        super.initEvents();

        GDispatcher.addEvent("PROGRESS", this.onProgress, this);
    }

    removeEvents() {
        super.removeEvents();

    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;

    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad(): void {
        Loading.instace.hide()

        this.progressBar=new ProgressBarS(this.perTxt)

        this["mainGroup"].addChild(this.progressBar)
    }
    onProgress(per) {
        console.log(per)
        var x = (562 - 54) * per + 54;
        egret.Tween.removeTweens(this.loadingMark)
        egret.Tween.get(this.loadingMark)
            .to({ x: x }, 200)
        egret.Tween.removeTweens(this.progressBar)
        egret.Tween.get(this.progressBar)
            .to({ value: per }, 200)
    }


}
