export default class ParticlesGoal extends eui.Group{
    private img0:eui.Image;
    private img1:eui.Image;

    private imgstr0:string;
    private imgstr1:string;

    constructor(imgstr0:string, imgstr1:string){
        super();
        this.imgstr0 = imgstr0;
        this.imgstr1 = imgstr1;

    }

    childrenCreated():void{
        super.childrenCreated();
        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.onLoad();
    }

    private onLoad():void{
        if(!this.img0){
            this.img0 = new eui.Image();
            this.img1 = new eui.Image();
            
            this.img0.width     = 35;
            this.img0.height    = 35;
            this.img1.width     = 35;
            this.img1.height    = 35;

            this.img0.anchorOffsetX = 17.5;
            this.img0.anchorOffsetY = 17.5;
            this.img1.anchorOffsetX = 17.5;
            this.img1.anchorOffsetY = 17.5;

            this.addChild(this.img0)
            this.addChild(this.img1);

        }

        this.img0.source = this.imgstr0;
        this.img1.source = this.imgstr1;

        this.aframe = 1;
    }

    public set aframe(idx:number){
        setTimeout(() => {
            
            if(idx == 1){
                this.img0.visible = true;
                this.img1.visible = false;

            }else{
                this.img0.visible = false;
                this.img1.visible = true;

            }
        }, 100);
    }
}