 import { IDynamicData } from './../../libs/tw/data/game/datapash/IDynamicData';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
import PanelCtrl from '../ctrls/panelCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { playSound, SoundType, toggleSound, playBg } from '../ctrls/soundCtrl';
import { GTime } from '../../libs/tc/util/GTime';
import { Buried } from '../../libs/tw/util/Buried';
import StartScene1 from '../startScene/StartScene';
import { GCache } from '../../libs/tc/util/GCache';
import { MyProgressBar } from '../ui/MyProgressBar';
import { AddScore } from '../ui/AddScore';
import { Particle } from './Particle';
import ParticlesGoal from './ParticlesGoal';
import SceneCtrl from '../ctrls/sceneCtrl';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
import { NetName } from '../../libs/tw/enum/NetName';

export default class GameScene extends Scene {
    public board:eui.Group;
    public barImg:eui.Image;
    public scoreLb:eui.Label;
    public netBack:eui.Image;
    public netFront:eui.Image;
    public barGroup:eui.Group;
    public guideMask:eui.Image;
    public basketball:eui.Group;
    public basketball0:eui.Label;
    public basketball1:eui.Label;

    private shadow:eui.Image;

    private addScore:AddScore;
    private timeBar:MyProgressBar;
    

    private world:any;
    private toRo:number;
    private materialBall:any;
    private materialPoint:any;
    private materialBoard:any;
    private materialPlane:any;
    private planeHeight:number;
    private isRight:boolean;
    private circleBody:any;
    private stepSpeed:number[];   //3.5正常速度，2慢速播放
    private detaTimeEf:number;
    private doubleHit:number;
    private timeMark:boolean;
    private timeLimit:number;
    private timeCount:number;
    private clickMark:boolean;
    private gravity:number;
    private score:number;


    private pool:any;

    private horizontal:number[];   //二值
    private verticalArea:number[];   //范围
    private verticalInit:number;
    private positionInitBall:any;
    private vertical:number;


    private loopMark:boolean;

    //碰撞标志位
    private inPointMark:boolean;
    private outPointMark:boolean;
    private boardMark:boolean;
    private pointMark:boolean;
    private planeMark:boolean;

    private stringMark;
    private ballAddSpeedX:number;
    private ballAddSpeedY:number;
    private timeSpeed:number;
    private ballSpeedLimitX;

    private btimes:number;

    //物理引擎p2
    private p2:any;
    //篮球相关物理配置
    private config;

    public get skinKey() { return 'GameScene' }
    public get groupName() { return 'game_scene' }

    constructor(data?) {
        super(data);
        if(this.data){
        }
    }

    initEvents() {
        super.initEvents();
        this.addEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onMouseDown, this);
    }

    removeEvents() {
        super.removeEvents();
        this.removeEventListener(egret.Event.ENTER_FRAME, this.onEnterFrame, this);
        this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onMouseDown, this);
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();

        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        this.bgtexture = await RES.getResAsync('gameBg_jpg');
        console.log('载背景并设置背景图片mainscene');


        // var mcJson = await RES.getResAsync('xinxingAct_json');
        // var mcImg = await RES.getResAsync('xinxingAct_png');
        // var mcFactory = new egret.MovieClipDataFactory(mcJson, mcImg);

        // this.xinxingAct = new egret.MovieClip(mcFactory.generateMovieClipData());

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private onLoad(): void {
        
        // const isGuide = GCache.readCache('isGuide');
        // if(!isGuide){
        //     GCache.writeCache('isGuide', 'true');
        //     this.guideMask.visible = true;
        //     this.guideMask.touchEnabled = false;
        // }
        this.guideMask.visible = true;
        this.guideMask.touchEnabled = false;

        this.showAct();
        this.initSceneData();
        this.initUI();  
    }

    private initUI(): void {
        this.shadow = new eui.Image();
        this.shadow.source = 'shadowImg_png';
        this.shadow.anchorOffsetX = 45;
        this.shadow.anchorOffsetY = 11;

        this.addChildAt(this.shadow, 1);

        //原来是1100
        this.shadow.y = 1100;
        this.shadow.x = -200;

        this.timeBar = new MyProgressBar(this.timeSpeed);
        this.barGroup.addChild(this.timeBar);
        this.addScore = new AddScore();
        this.addScore.anchorOffsetX = 268;
        this.addScore.anchorOffsetY = 82;
        this.addScore.x = 112 + 268;
        this.addScore.y = 135 + 82;
        this.addChild(this.addScore)
        this.addScore.aframe = -1;
        this.addScore.alpha = 0;
        // this.addScore.score = 30;


        this.score = 0;
        this.vertical = this.verticalInit;
        this.isRight = false;
        this.basketball.x = this.positionInitBall.x;
        this.basketball.y = this.positionInitBall.y;

        this.basketball0.visible = false;
        this.basketball1.visible = true;

        this.basketball['body'].position[0] = this.positionInitBall.x / 100;
        this.basketball['body'].position[1] = -this.positionInitBall.y / 100;
        this.basketball['body'].interpolatedPosition[0] = this.positionInitBall.x / 100;
        this.basketball['body'].interpolatedPosition[1] = -this.positionInitBall.y / 100;
        this.resetPositionView();
        this.resetPositionBody();

        this.clickMark = true;


        
    }

    //初始化界面数据
    private initSceneData(): void {
        this.btimes = 0;
        this.config = {
            net: {//篮框位置
                x: 9,
                y: 45
            },
            insidePointBody: {//靠近篮板的点
                x: 15,
                y: 45,
                radius: 0.07
            },
            outsidePointBody: {//另外一端
                x: 175,
                y: 45,
                radius: 0.05
            },
            boardBody: {//篮板缸体
                x: 0,
                y: 0,
                // length: 2,
                // radius: 0.1,
                width: 0.3,
                height: 2,
            },
            upSensorBody: {//篮框上方刚体
                x: 100,
                y: 65,
                radius: 0.05
            },
            downSensorBody: {//篮框下方刚体
                x: 100,
                y: 65 + 80,
                radius: 0.05
            }
    
        };
        
        this.pool = {};

        this.horizontal = [83, 676];   //二值 篮板y值
        this.verticalArea = [300, 600];   //范围
        this.verticalInit = 462 - 45;//篮板初始x值
        this.positionInitBall = {
            x: 557,
            y: 805
        }
        this.vertical = this.verticalInit;


        this.planeHeight = 1100;//地板高度
        this.stringMark = '';
        this.isRight = false;
        this.doubleHit = 0;
        this.gravity = -5;
        this.stepSpeed = [0.5, 3.5];
        this.detaTimeEf = this.stepSpeed[1];
        this.timeLimit = window["timeLimit"] ? window["timeLimit"] : 5;
        this.timeCount = this.timeLimit;
        this.timeMark = false;
        this.clickMark = false;

        
        this.inPointMark = false;
        this.outPointMark = false;
        this.boardMark = false;
        this.pointMark = false;
        this.planeMark = false;

        this.loopMark = false;
        this.timeSpeed = 1 / 60;
        this.toRo = 180 / Math.PI;
        this.ballSpeedLimitX = 3;
        this.ballAddSpeedX = 1.2;
        this.ballAddSpeedY = 5.3;

        this.initWorld();
        this.initMaterial();
        this.createBasketball();
        this.createCollArea();
        this.doCollision();
    }

    //初始化世界
    private initWorld():void{

        //全局p2
        this.p2 = window["p2"]
        //模拟世界
        var wrd = new p2.World();
        wrd.sleepMode = p2.World.BODY_SLEEPING;
        wrd.gravity = [0, this.gravity];
        this.world = wrd;

        this.world.defaultContactMaterial.friction = 0.3;
        this.world.defaultContactMaterial.restitution = 0.6
        this.world.setGlobalStiffness(1e5);
    }

    //创建材质
    private initMaterial():void{
        //材质
        this.materialBall = new this.p2.Material();
        this.materialPoint = new this.p2.Material();
        this.materialBoard = new this.p2.Material();
        this.materialPlane = new this.p2.Material();
        var contactMaterialBallPoint = new this.p2.ContactMaterial(this.materialBall, this.materialPoint, {
            friction: 0.3,
            restitution: 0.5,
            // stiffness:0.1,
            // relaxation:0
        })
        var contactMaterialBallBoard = new this.p2.ContactMaterial(this.materialBall, this.materialBoard, {
            friction: 0.3,
            restitution: 0.5,
            // stiffness:0.1,
            // relaxation:0
        })
        var contactMaterialBallPlane = new this.p2.ContactMaterial(this.materialBall, this.materialPlane, {
            friction: 0.3,
            restitution: 0.7,
            // stiffness:0.1,
            // relaxation:0
        })
        this.world.addContactMaterial(contactMaterialBallPoint);
        this.world.addContactMaterial(contactMaterialBallBoard);
        this.world.addContactMaterial(contactMaterialBallPlane);

    }

    //创建篮板篮球等
    private createBasketball():void{
        //篮板
        // var box = new p2.Capsule({
        //     length: 2,
        //     radius: 0.1,
        // });
        var box = new this.p2.Box({
            width: this.config.boardBody.width,
            height: this.config.boardBody.height,
            material: this.materialBoard
        });
        var boxBody = new this.p2.Body({
            mass: 0,
            // position: [7.1, -4.6],
            type: this.p2.Body.STATIC,
            // angle: Math.PI / 2
        });
        boxBody.addShape(box);
        boxBody.nameCus = "board"
        this.world.addBody(boxBody);
        this.board['boardBody'] = boxBody;

        //框点
        var circleShape = new this.p2.Circle({
            radius: this.config.outsidePointBody.radius,
            material: this.materialPoint
        });

        this.circleBody = new this.p2.Body({
            mass: 0,
            // position: [5.65, -5.5],
            type: this.p2.Body.STATIC
        });
        this.circleBody.addShape(circleShape);
        this.circleBody.nameCus = "out"
        this.world.addBody(this.circleBody);
        this.board['outsidePointBody'] = this.circleBody;

        var circleShape1 = new this.p2.Circle({
            radius: this.config.insidePointBody.radius,
            material: this.materialPoint
        });
        var circleBody1 = new this.p2.Body({
            mass: 0,
            // position: [5.65, -5.5],
            type: this.p2.Body.STATIC
        });
        circleBody1.addShape(circleShape1);
        circleBody1.nameCus = "in"
        this.world.addBody(circleBody1);
        this.board['insidePointBody'] = circleBody1;


        //地板
        // Add a ground plane
        var planeShape = new this.p2.Plane({
            material: this.materialPlane
        });
        var planeBody = new this.p2.Body({
            position: [3.75, -this.planeHeight / 100]
        });
        planeBody.nameCus = "plane"
        planeBody.addShape(planeShape);
        this.world.addBody(planeBody);


        //篮球
        var shape = new this.p2.Circle({
            radius: 0.6 * 0.9,
            material: this.materialBall
        });
        this.basketball['body'] = new this.p2.Body({
            mass: 0.1,
            // position: [557 / 100, -611 / 100],
            // position: [this.basketball.x / 100, -this.basketball.y / 100]
        })
        this.basketball['body'].nameCus = "ball";
        this.basketball['body'].addShape(shape);
        this.world.addBody(this.basketball['body']);
        this.basketball.scaleX = 0.9;
        this.basketball.scaleY = 0.9;
        // console.log(this.basketball.body)
    }

    //创建进球感应区
    private createCollArea():void{
        //进球感应区域
        var sensorShape = new this.p2.Circle({
            radius: this.config.upSensorBody.radius
        });
        sensorShape.sensor = true;
        var sensorBody = new this.p2.Body({
            // position: [this.config.upSensorBody.x, this.config.upSensorBody.y]
        });
        sensorBody.damping = 0;
        sensorBody.nameCus = "up";
        sensorBody.addShape(sensorShape);
        this.board['upSensorBody'] = sensorBody;
        this.world.addBody(sensorBody);

        var sensorShape1 = new this.p2.Circle({
            radius: this.config.downSensorBody.radius
        });
        sensorShape1.sensor = true;
        var sensorBody1 = new this.p2.Body({
            // position: [this.config.downSensorBody.x, this.config.downSensorBody.y]
        });
        sensorBody1.damping = 0;
        sensorBody1.nameCus = "down";
        sensorBody1.addShape(sensorShape1);
        this.board['downSensorBody'] = sensorBody1;
        this.world.addBody(sensorBody1);
    }

    //处理碰撞回调
    private doCollision():void{
        //contactPointA 相对于bodyA的碰撞点位置，
        //contactPointB 相对于bodyB的碰撞点位置，

        this.world.on("beginContact",this.onBeginContact.bind(this));
        this.world.on("endContact", (e)=>{
            let col = e.bodyA.nameCus + e.bodyB.nameCus;
            if (col.indexOf("up") >= 0) {
                this.stringMark = "";
            }
            if (col.indexOf("down") >= 0) {
                this.stringMark = "";
            }
        })
    }

    private onBeginContact(e):void{

        let boardMarkSetTime;
        let pointMarkSetTime;

        let direction = this.isRight ? -1 : 1;
        // console.log(e.contactEquations)
        if (e.bodyB == this.circleBody) {
            // console.log('55555',e.contactEquations[0].contactPointB[1])
            if (e.bodyA.velocity[1] < -5 && e.contactEquations[0].contactPointB[1] < -0.4) {
                this.netFront.rotation = 0;
                this.netBack.rotation = 0;
                egret.Tween.get(this.netFront).to({rotation: 5 * direction}, 33).to({rotation: 0}, 33);
                egret.Tween.get(this.netBack).to({rotation: 5 * direction}, 33).to({rotation: 0}, 33);
            }
        } else if (e.bodyA == this.circleBody) {
            // console.log('666666',e.contactEquations[0].contactPointA[1])
            if (e.bodyB.velocity[1] < -5 && e.contactEquations[0].contactPointA[1] < -0.4) {
                this.netFront.rotation = 0;
                this.netBack.rotation = 0;
                egret.Tween.get(this.netFront).to({rotation: 5 * direction}, 33).to({rotation: 0}, 33);
                egret.Tween.get(this.netBack).to({rotation: 5 * direction}, 33).to({rotation: 0}, 33);
            }
        }
        // console.log(e.bodyA.nameCus, e.bodyB.nameCus)
        // console.log(e.bodyA.nameCus+e.bodyB.nameCus)
        let col = e.bodyA.nameCus + e.bodyB.nameCus;
        // console.log('col',col)
        if (col.indexOf("up") >= 0) {
            this.stringMark += "up";
        }
        // console.log(' this.stringMark',this.stringMark)
        if (col.indexOf("down") >= 0) {
            this.stringMark += "down";
            if (this.stringMark == "updown") {
                //篮板破裂。并出现粒子
                if (this.doubleHit >= 2) {
                    this.basketball0.visible = true;
                    this.basketball1.visible = false;
                    // this.view.board.gotoAndStop(2);
                    this.createParticlesBroke();
                    //抖动；
                    egret.Tween.get(this).to({x: -20}, 33).call(()=>{
                        egret.Tween.get(this).to({x: 20}, 33).call(()=>{
                            egret.Tween.get(this).to({x: 0}, 33);
                        })
                    });
                }

                //计时开始
                if (this.score == 0) this.timeMark = true;
                if (this.detaTimeEf == this.stepSpeed[0]) {
                    this.detaTimeEf = this.stepSpeed[1]
                    this.timeMark = true;
                    this.clickMark = true;
                }
                
                this.timeBar.imgSource = 0;
                // this.view.timeBar.bar.gotoAndStop(1);切换进度条颜色，预留
                this.timeCount = this.timeLimit;
                //算分
                this.calcScore();
                this.basketball['body'].velocity[0] *= 0.5;
                this.basketball['body'].velocity[1] *= 0.5;
                this.handleGoal();
                this.doubleHit += 1;

            }
        }

        //通过碰撞获取状态
        if (col.indexOf("board") >= 0) {
            this.boardMark = true;
            window["clearTimeout"](boardMarkSetTime);
            boardMarkSetTime = window["setTimeout"](() => {
                this.boardMark = false;
            }, 1000)
        }
        if (col.indexOf("in") >= 0 || col.indexOf("out") >= 0) {
            this.pointMark = true;
            window["clearTimeout"](pointMarkSetTime);
            pointMarkSetTime = window["setTimeout"](() => {
                this.pointMark = false;
            }, 1000)
        }
        if (col.indexOf("plane") >= 0) {
            this.doubleHit = 0;
            
            this.basketball0.visible = false;
            this.basketball1.visible = true;
            // this.basketball.gotoAndStop(1);//切换篮球状态，预留
        }

        // console.log(e)
        // console.log(e.bodyB.velocity[1])
        // console.log(e.contactEquation.bodyB.velocity[1])
        // console.log(e.contactEquation.penetrationVec[0],e.contactEquation.penetrationVec[1])
        // console.log(e.contactEquation.contactPointB[0],e.contactEquation.contactPointB[1])
    }

    private calcScore() {
        let btype = 2;
        //20空心球，10打板球，5察框球
        var baseScore = 20;
        if (this.pointMark) {
            btype = 0;
            baseScore = 5;
        } else if (this.boardMark) {
            baseScore = 10;
            btype = 1;
        }
        var addScore = 0;
        if (this.doubleHit > 0) {
            addScore += this.doubleHit + 1
        }

        //算toast显示，
        //1空心无连击
        //2空心连击
        //3空心连击*2
        //4打板无连击，
        //5打板连击，
        //6打板连击*2，
        //7擦框无连击
        //8察框连击
        //9察框连击*2
        var frame;
        if (baseScore == 20) {
            if (this.doubleHit == 0) {
                frame = 1;
            } else if (this.doubleHit == 1) {
                frame = 2;
            } else {
                frame = 3;
            }
        } else if (baseScore == 10) {
            if (this.doubleHit == 0) {
                frame = 4;
            } else if (this.doubleHit == 1) {
                frame = 5;
            } else {
                frame = 6;
            }
        } else {
            if (this.doubleHit == 0) {
                frame = 7;
            } else if (this.doubleHit == 1) {
                frame = 8;
            } else {
                frame = 9;
            }
        }
        var scoreOnce = addScore + baseScore;//本次投篮增加分数
        //分数增加动画，预留
        this.addScore.aframe = frame;
        //设置显示连击数
        if(frame == 3 || frame == 6 || frame == 9){
            this.addScore.ljNum = this.doubleHit;
        }
        this.addScore.score = scoreOnce;
        this.btimes ++;
        this.postScore(btype, (this.doubleHit <= 0 ? 0 : 1), this.btimes);

        this.addScore.x = 112 + 268;
        this.addScore.y = 135 + 82;
        this.addScore.alpha = 1;
        this.addScore.scaleX = 0;
        this.addScore.scaleY = 0;

        egret.Tween.get(this.addScore)
        .to({scaleX:1.2, scaleY:1.2},250)
        .to({scaleX:1, scaleY:1}, 170)
        .to({x:700 + 308}, 500, egret.Ease.backIn);

        this.score += scoreOnce;

        this.scoreLb.text = this.score + '';
        console.log('score=', this.score);
    }

    //进球后操作
    private handleMark = false;
    private handleGoal() {
        if (!this.handleMark) {
            this.handleMark = true;
        } else {
            return
        }
        //进球后加特效
        this.createParticlesGoal();
        // this.createParticlesBroke();
        this.isRight = !this.isRight;
        let direction = this.isRight ? 1 : -1;
        this.vertical = this.randomT(this.verticalArea[0], this.verticalArea[1]);
        let self = this;

        setTimeout(() => {
            this.resetPositionBody();

            egret.Tween.get(this.board).to({x:this.board.x - 150 * direction}, 5 * 33).call(()=>{
                this.resetPositionView();
            });

            egret.Tween.get(this.netBack).to({x:this.netBack.x - 150 * direction}, 5 * 33);
            egret.Tween.get(this.netFront).to({x:this.netFront.x - 150 * direction}, 5 * 33);

        }, 100)



    }
    // 12位数字字符串，1-6 指示 type，前六位第二位指示有效值索引， 7-12指示是否连击，后六位第一位指示有效数字。
    private postScore(type:number, isLianji:number, count:number):void{
        const idxArr0 = [0, 2, 3, 4, 5];
        const idxArr1 = [1, 2, 3, 4, 5];

        let scoreStr = '';

        let idx0 = idxArr0[Math.floor(Math.random() * idxArr0.length)];
        for(let i = 0; i < 6; i++){
            if(i == 1){
                scoreStr += idx0;
            }else{
                if(i == idx0){
                    scoreStr += type;
                }else{
                    scoreStr += Math.floor(Math.random() * 10);
                }
            }
        }

        let idx1 = idxArr1[Math.floor(Math.random() * idxArr1.length)];
        for(let i = 0; i < 6; i++){
            if(i == 0){
                scoreStr += idx1;
            }else{
                if(i == idx1){
                    scoreStr += isLianji;
                }else{
                    scoreStr += Math.floor(Math.random() * 10);
                }
            }
        }

        scoreStr += count;

        scoreStr += Math.floor(Math.random() * 10);

        //阶段性提交分数
        let data = DataManager.ins.getData(NetName.DO_START).data;
        NetManager.ins.doDataPush((success)=>{
            if(!success){
                console.log('dataPush field');
            }
        },scoreStr, data.recordId);
    }


    private resetPositionBody() {
        var scaleX = this.isRight ? -1 : 1;
        var baseX = this.horizontal[~~this.isRight];
        var baseY = this.vertical;
        this.board['boardBody'].position[0] = baseX / 100;
        this.board['boardBody'].position[1] = -baseY / 100;
        this.board['outsidePointBody'].position[0] = (baseX + this.config.outsidePointBody.x * scaleX) / 100;
        this.board['outsidePointBody'].position[1] = -(baseY + this.config.outsidePointBody.y) / 100;
        this.board['insidePointBody'].position[0] = (baseX + this.config.insidePointBody.x * scaleX) / 100;
        this.board['insidePointBody'].position[1] = -(baseY + this.config.insidePointBody.y) / 100;

        this.board['upSensorBody'].position[0] = (baseX + this.config.upSensorBody.x * scaleX) / 100;
        this.board['upSensorBody'].position[1] = -(baseY + this.config.upSensorBody.y) / 100;
        this.board['downSensorBody'].position[0] = (baseX + this.config.downSensorBody.x * scaleX) / 100;
        this.board['downSensorBody'].position[1] = -(baseY + this.config.downSensorBody.y) / 100;
    }

    private resetPositionView() {
        var scaleX = this.isRight ? -1 : 1;
        var baseX = this.horizontal[~~this.isRight];
        var baseY = this.vertical;

        this.board.x = baseX;
        this.board.y = baseY;
        this.board.scaleX = scaleX;

        this.netFront.x = baseX + this.config.net.x * scaleX;
        this.netFront.y = baseY + this.config.net.y;
        this.netFront.scaleX = scaleX;

        this.netBack.x = baseX + this.config.net.x * scaleX;
        this.netBack.y = baseY + this.config.net.y;
        this.netBack.scaleX = scaleX;

        this.handleMark = false;

        //预留
        // var self = this;
        // annie.Tween.from(this.view.board, 5, {
        //     x: this.view.board.x - 150 * scaleX,
        //     useFrame: true,
        //     onComplete: function () {
        //         self.handleMark = false;
        //     }
        // })
        // annie.Tween.from(this.view.netFront, 5, {
        //     x: this.view.netFront.x - 150 * scaleX,
        //     useFrame: true,
        // })
        // annie.Tween.from(this.view.netBack, 5, {
        //     x: this.view.netBack.x - 150 * scaleX,
        //     useFrame: true,
        // })

    }
    private lastTime

    private shadowHeightLimit = 600;
    private ballRadius = 60;
    private aEff = 1 / (this.ballRadius - this.shadowHeightLimit);
    private bEff = this.shadowHeightLimit / (this.shadowHeightLimit - this.ballRadius);

    private onEnterFrame(e){
        if (!this.loopMark) return;
        // console.log(this.basketball['body'].velocity[1])
        this.basketball.x = this.basketball['body'].interpolatedPosition[0] * 100;
        this.basketball.y = -this.basketball['body'].interpolatedPosition[1] * 100;
        // console.log(this.basketball.x,this.basketball.y)
        this.basketball.rotation = -this.basketball['body'].interpolatedAngle * this.toRo;

        if (this.basketball.x < -100) {
            this.basketball['body'].position[0] = 7.5 + 1;
        }
        if (this.basketball.x > 750 + 100) {
            this.basketball['body'].position[0] = - 1;
        }
        this.shadow.x = this.basketball.x;
        var lamd = 600;
        var scale = this.aEff * (this.planeHeight - this.basketball.y) + this.bEff
        if (scale <= 0.2) {
            this.shadow.visible = false;
        } else {
            this.shadow.visible = true;
        }
        this.shadow.scaleX = this.shadow.scaleY = scale


        var time = Date.now()
        var dt = this.lastTime ? (time - this.lastTime) / 1000 : 0;
        dt = Math.min(1 / 10, dt);
        this.lastTime = time;
        //更新引擎
        this.world.step(1 / 60, dt * this.detaTimeEf, 10);
        // this.world.step(1 / 60, dt*0.5, 10);
        // this.world.step(1 / 60)


        //雪花
        for (let i = this.particlesGoal.length - 1; i >= 0; i--) {
            let p = this.particlesGoal[i];
            p.update();
            if (p.dieMark) {
                this.particlesGoal.splice(i, 1);
                this.removeChild(p.view);
                this.recover("particlesGoal", p);
            }
        }

        this.createParticlesFollow()
        for (let i = this.particlesFollow.length - 1; i >= 0; i--) {
            let p = this.particlesFollow[i];
            p.update();
            if (p.dieMark) {
                this.particlesFollow.splice(i, 1);
                this.removeChild(p.view);
                this.recover("particlesFollow", p);
            }
        }

        //计时
        if (this.timeMark) {
            this.timeCount -= this.timeSpeed;
            if(this.timeCount < 0){
                this.timeCount = 0;
            }
            // this.view.time.text = this.timeCount >> 0;

            if (this.timeCount < 2) {//预留
                this.timeBar.imgSource = 1;
            }

            this.timeBar.barVal = Math.floor((this.timeCount / this.timeLimit) * 100);
            
            if (this.timeCount <= 0) {
                this.timeCount = this.timeLimit;
                this.detaTimeEf = this.stepSpeed[0];
                this.timeMark = false;
                this.clickMark = false;
            }
        } else if (this.detaTimeEf == this.stepSpeed[0]) {
            // console.log('this.basketball.y=',this.basketball.y)
            // console.log('this.vertical + 400',this.vertical + 400)
            if (this.basketball.y > this.vertical + 400) {//游戏结束
                console.log('游戏结束')
                let data = DataManager.ins.getData(NetName.GET_INDEX).data;
                if(data.cardCount > 0){
                    PanelCtrl.instance.show(ModuleTypes.USE_PROP_PANE, this.score);
                }else{
                    this.submit();
                }
               
                this.loopMark = false;
            }
        }else{
            // console.log(333333);
        }


        //限制横向速度
        // console.log(this.basketball['body'].velocity[0])
        if (Math.abs(this.basketball['body'].velocity[0]) > this.ballSpeedLimitX) {
            this.basketball['body'].velocity[0] *= 0.5
        }
        // if(this.pool["particlesGoal"])console.log(this.pool["particlesGoal"].length)
    }

    protected onMouseDown(e): void {
        // this.Body.setVelocity(this.basketball.body, { x: 8, y: -40 });
        // this.Body.setAngularVelocity(this.basketball.body,0.3)
        // this.Body.applyForce(this.basketball.body,this.basketball.body.position,{x:0,y:-5})

        // this.basketball.body.applyImpulse([1, 10])

        if (!this.clickMark) return;
        
        this.guideMask.visible = false;
        this.loopMark = true;
        var direction = this.isRight ? 1 : -1;
        this.basketball['body'].velocity[0] = this.ballAddSpeedX * direction;
        this.basketball['body'].velocity[1] = this.ballAddSpeedY;
        this.basketball['body'].angularVelocity = -2 * direction
    }

    private submit():void{
        let data = DataManager.ins.getData(NetName.DO_START).data;
        NetManager.ins.doSubmit((success)=>{
            if(success){
                PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL);
            }else{
                let data = DataManager.ins.getData(NetName.DO_SUBMIT);
                if(data){
                    if(data.code){
                        if(data.code == '100102'){//生成签名异常
                            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, '数据异常');
                        }else if(data.code == '100103'){//签名错误
                            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, '数据异常');
                        }else if(data.code == '100101'){//游戏分数异常
                            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, '您本局的游戏数据存在异常，请遵守游戏规则哟');
                        }else{
                            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, '啊哦，网络开小差了~');
                        }
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, '啊哦，网络开小差了~');
                    }
                }else{
                    PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, '啊哦，网络开小差了~');
                }

            }
        }, data.recordId, this.score, NetManager.ins.createSgin1(data.recordId, this.score, false, data.token), false);
    }


    private particlesGoal = [];

    private createParticlesGoal() {
        let self = this;
        for (let i = 0; i < 20; i++) {
            let p = this.takeOut("particlesGoal");
            let direction = this.isRight ? -1 : 1;
            var baseX = this.horizontal[~~this.isRight];
            let x = baseX + 100 * direction;
            let y = self.vertical + 150;
            let vx = self.randomT(-5, 5);
            let vy = self.randomT(-10, -20);
            let maxLife = self.randomT(20, 50);
            if (!p) {
                // let view = new annie.Shape();
                // view.clear();
                // view.beginFill("#ff0000");
                // view.drawRect(-10, -10, 20, 20);
                // view.endFill();
                let view = new ParticlesGoal('partical11_png', 'partical10_png');
                view.touchChildren = false;
                view.touchEnabled = false;
                view.rotation = self.randomT(0, 360);
                view.alpha = this.randomT(0.8, 1);
                p = new Particle(x, y, vx, vy, maxLife, view);
                p.alphaSpeed = 0.01;
            } else {
                p.init(x, y, vx, vy, maxLife);
                p.view.aframe = 1;
                p.view.alpha = this.randomT(0.8, 1);
            }

            this.addChild(p.view);
            this.particlesGoal.push(p);
        }
    }

    private particlesBroke = [];
    private createParticlesBroke() {
        let self = this;
        let direction = this.isRight ? 1 : -1;
        var baseX = this.horizontal[~~this.isRight];
        for (let i = 0; i < 20; i++) {
            let p = this.takeOut("particlesGoal");
            let x = baseX + self.randomT(-20, 20)
            let y = self.vertical + self.randomT(-100, 20);
            let vx = self.randomT(0, -10 * direction);
            let vy = self.randomT(-10, 5);
            let maxLife = self.randomT(20, 50);
            if (!p) {
                // let view = new annie.Shape();
                // view.clear();
                // view.beginFill("#ff0000");
                // view.drawRect(-10, -10, 20, 20);
                // view.endFill();
                let view = new ParticlesGoal('partical11_png', 'partical10_png');
                view.touchChildren = false;
                view.touchEnabled = false;
                view.aframe = 2;
                view.rotation = self.randomT(0, 360);
                view.alpha = this.randomT(0.8, 1);
                p = new Particle(x, y, vx, vy, maxLife, view);
                p.alphaSpeed = 0.01;
            } else {
                p.init(x, y, vx, vy, maxLife);
                p.view.aframe = 2;
                p.view.alpha = this.randomT(0.8, 1);
            }

            this.addChild(p.view);
            this.particlesGoal.push(p);
        }
    }

    private particlesFollow = [];
    private createParticlesFollow() {
        let self = this;

        let p = this.takeOut("particlesFollow");
        let x = self.basketball.x + self.randomT(-40, 40);
        let y = self.basketball.y + self.randomT(-40, 40);
        let vx = 0;
        let vy = 1;
        let maxLife = self.randomT(10, 30);
        if (!p) {
            // let view = new annie.Shape();
            // view.clear();
            // view.beginFill("#ff0000");
            // view.drawRect(-10, -10, 20, 20);
            // view.endFill();
            let view = new ParticlesGoal('partical00_png', 'partical01_png');
            view.touchChildren = false;
            view.touchEnabled = false;
            if (self.doubleHit > 2) {
                view.aframe = 2;
            } else {
                view.aframe = 1;
            }
            view.scaleX = view.scaleY = this.randomT(0.5, 1);
            p = new Particle(x, y, vx, vy, maxLife, view);
            view.alpha = this.randomT(0.8, 1);
            p.alphaSpeed = 0.03;
            p.gravity = 0;
            // p.scaleSpeed=0.005
            p.scaleSpeed = 0;
        } else {
            p.init(x, y, vx, vy, maxLife);
            p.view.scaleX = p.view.scaleY = this.randomT(0.5, 1);
            p.view.alpha = this.randomT(0.8, 1);
            if (self.doubleHit > 2) {
                p.view.aframe = 2;
            } else {
                p.view.aframe = 1;
            }
        }

        this.addChildAt(p.view, 3);
        this.particlesFollow.push(p);

    }

    private takeOut(name) {
        if (this.pool[name] && this.pool[name].length) {
            return this.pool[name].shift();
        }
        return false;
    }
    private recover(name, obj) {
        if (!this.pool[name]) {
            this.pool[name] = [];
        }
        this.pool[name].push(obj);
    }
    
    private randomT(e, n?) {
        return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e))
    }

}


// //总分
// private aScore:number = 0;
// //连击次数
// private lianji:number = 0;
// //计算单次分数，并附加到总分上
// private addScore1(isLianji:boolean, type:number):number{

//     //基础分数
//     let baseScore = 0;
//     switch(type){
//         case 0:
//             baseScore = 5;
//             break;
//         case 1:
//             baseScore = 10;
//             break;
//         case 2:
//             baseScore = 20;
//             break;
//     }
//     const currScore = baseScore + this.lianji;
//     this.aScore += currScore;

    
//     if(isLianji){
//         this.lianji ++;
//     }else{
//         this.lianji = 0;
//     }

//     return this.aScore;
// }