import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
export default class TimesTipsPanel extends Panel {
    public okBtn:eui.Button;
    private mData:any;

    public get skinKey() { return 'TimeTipsPanel' }
    public get groupName() { return 'timetips_panel'}

    constructor(data?:any){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap1, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap1, this);
    }

    private onLoad():void{
        if(this.mData == '0'){
            this['txtImg0'].visible = true;
            this['txtImg1'].visible = false;
        }else{
            this['txtImg0'].visible = false;
            this['txtImg1'].visible = true;
        }
    }

    private onTap1():void{
        PanelCtrl.instance.btnDelay(this.okBtn);
        this.hidePanel();
        
    }

    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }
        this.onTap1();
    }
}