
import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
export default class MsgPanel extends Panel {
    private mData: IMsgData;
    private okBtn:eui.Button;
    public titleImg:eui.Image;
    public textLabel:eui.Label;
    public textLabel0:eui.Label;
    public textLabel1:eui.Label;
    private againBtn:eui.Button;
    private loginBtn:eui.Button;
    public starIconImg:eui.Image;

    // private tfArr:egret.TextField[];

    public get skinKey() { return 'Msg' }
	public get groupName() { return 'msg_panel'}
    
    constructor(data?:IMsgData){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
		}
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        if(this.mData && this.mData.btnName){
            this[this.mData.btnName].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
        }
    }

    removeEvents():void{
        super.removeEvents();
        this[this.mData.btnName].removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onLoad():void{

        this.okBtn.name     = 'okBtn';
        // this.againBtn.name  = 'againBtn';
        // this.loginBtn.name  = 'loginBtn';

        if(this.mData){
            this.setBtn();
            console.log('this.mData.titleIdx='+this.mData.titleIdx);
        }else{
            console.log("this.mData和this.mData.msgArr为必传项！");
            return;
        }

        if(this.mData.titleIdx > 3){
            this.starIconImg.x = 593;
            this.starIconImg.y = 350;
            this.titleImg.visible = true;

            this.textLabel.visible = true;
            this.textLabel0.visible = true;
            this.textLabel1.visible = false;
            this.textLabel0.text = this.mData.msg0 ? this.mData.msg0 : '';
            this.textLabel.text = this.mData.msg ? this.mData.msg: '';
        }else{
            this.textLabel.visible = false;
            this.textLabel0.visible = false;
            this.textLabel1.visible = true;

            this.starIconImg.x = 552;
            this.starIconImg.y = 336;
            this.titleImg.visible = false;
        }

        this.showAct();

        
    }

    private onTap(e:egret.TouchEvent):void{
        PanelCtrl.instance.btnDelay(this[this.mData.btnName]);
        this.hidePanel();

        if(this.mData && this.mData.callBack){
            this.mData.callBack();
        }
    }

    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }

        if(this.mData && this.mData.closeCallBack){
            this.mData.closeCallBack();
        }
    }

    private setBtn():void{
        this['okBtn'].visible       = false;
        // this['againBtn'].visible    = false;
        // this['loginBtn'].visible    = false;

        this[this.mData.btnName].visible = true;
    }

}

export interface IMsgData{
    btnName:string,
    titleIdx:number,
    msg?:string,
    msg0?:string,
    callBack?:Function,
    closeCallBack?:Function
}