import { Buried } from './../../libs/tw/util/Buried';
import { ModuleTypes } from './../types/sceneTypes';
import Panel from "../views/Panel";
import SceneCtrl from '../ctrls/sceneCtrl';
import { DataManager } from '../../libs/tw/manager/DataManager';
import { NetManager } from '../../libs/tw/manager/NetManager';

export default class GuidePanel extends Panel {
    public actGroup:eui.Group;
    public tipsImg:eui.Image;
    public handImg:eui.Image;
    public bgmask:eui.Rect;

    public get skinKey() { return 'Guide' }
    public get groupName() { return 'guide_panel'}

    onSkinComplete():void{
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct(function(){
            this.showMaskAct();
        }.bind(this));
    }

    start():void{
        this.percentHeight = 100;
        
    }

    initEvents():void{
        super.initEvents();
        this.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    removeEvents():void{

        this['act0'].pause();
        super.removeEvents();
        this.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap, this);
    }

    private onLoad():void{
        this.handImg.alpha  = 0;
        this.tipsImg.alpha  = 0;
        this.bgmask.visible = false;
    }

    private onTap():void{
        this.hidePanel();
        SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
    }

    onTouchTap():any{
        super.onTouchTap();
        this.onTap();

        // //引导点击
        // let startDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        // let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        // let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        // NetManager.ins.clickLog(exposure);
    }

    //遮罩动画
    private showMaskAct():void{

        this.bgmask.visible = true; 

        var shape:egret.Shape = new egret.Shape();
        shape.graphics.beginFill(0);
        shape.graphics.drawCircle(0,0,810);
        shape.graphics.endFill();

        this.panelGroup.addChild(shape);
        shape.x = 375;
        shape.y = 360;//810;
        // shape.anchorOffsetX = 405;
        // shape.anchorOffsetY = 405;


        this.actGroup.visible = true;
        this.actGroup.mask = shape;
        // shape.width = 1000;
        // shape.height = 1000;

        this.actGroup.mask = shape; 
        const endScale = 60 / 810;
        
        egret.Tween.get(shape).to({scaleX:endScale, scaleY:endScale},300,egret.Ease.cubicOut).call(function(){
            this.handImg.alpha  = 1;
            this.playAnimation(this['act0']);
            egret.Tween.get(this.tipsImg).to({y:this.tipsImg.y + 50, alpha:1}, 300, egret.Ease.cubicOut);
        }.bind(this));
    }

    //循环播放动画
	private playAnimation(target:egret.tween.TweenGroup,isLoop:boolean = true):void
	{
		if(isLoop)
		{
			for(var key in target.items)
			{
				target.items[key].props = {loop:true};
			}
		}
		target.play();
	}
}