import Panel from "../views/Panel";
import PanelCtrl from "../ctrls/panelCtrl";
import { DataManager } from "../../libs/tw/manager/DataManager";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { Buried } from "../../libs/tw/util/Buried";
import { NetManager } from "../../libs/tw/manager/NetManager";
import Loading from "../loading/Loading";
import { GDispatcher } from "../../libs/tc/util/GDispatcher";
export default class GameOverPanel extends Panel {
    public okBtn:eui.Button;
    public desLb:eui.Label;
    public titleLb:eui.Label;
    public resultLb:eui.Label;
    public shareTipsLb:eui.Label;
    public shareBtn:eui.Button;
    public iknowBtn:eui.Button;
    public closeBtn:eui.Button;
    public moreBtn:eui.Button;
    private mData:any;

    public get skinKey() { return 'GameOverPanel' }
    public get groupName() { return 'gameover_panel'}

    constructor(data?:any){
        super(data);

        this.mData = data;
    }

    onSkinComplete():void{
        super.onSkinComplete();
        this.once(egret.Event.ADDED_TO_STAGE,this.onLoad,this);
		if(this.stage){
			this.onLoad();
        }
        
        this.showAct();
    }

    start():void{
        this.percentHeight = 100;
    }

    initEvents():void{
        super.initEvents();
        this.okBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap1, this);
        this.moreBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_moreBtn, this);
        this.iknowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_iknowBtn, this);
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
        this.closeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    removeEvents():void{
        super.removeEvents();
        this.okBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap1, this);
        this.moreBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_moreBtn, this);
        this.iknowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_iknowBtn, this);
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this);
        this.closeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_closeBtn, this);
    }

    private onTap_moreBtn():void{
        PanelCtrl.instance.btnDelay(this.moreBtn);
        
        if(window['moreGame']){
            window.location.href = window['moreGame'];
        }

        this.goStart();
    }

    private onTap_iknowBtn():void{
        PanelCtrl.instance.btnDelay(this.iknowBtn);
        
        if(this.mData && this.mData.type == 2){
            const startDpmOut1 = Buried.connectDpm(110, 11, 1); // 点击埋点   
            const startDcmOut1 = Buried.connectDcm(202, 0, 0); // 曝光埋点
            const exposure1 = Buried.createExposure(startDpmOut1, startDcmOut1);

            NetManager.ins.clickLog(exposure1);

        }else{
            const startDpmOut = Buried.connectDpm(110, 9, 1); // 点击埋点   
            const startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            const exposure = Buried.createExposure(startDpmOut, startDcmOut);

            NetManager.ins.clickLog(exposure);
        }

        this.goStart();
    }

    private onTap_closeBtn():void{
        console.log('this.goStart();')
        this.goStart();
    }

    private goStart():void{
        this.onTouchTap();
        console.log('this.goStart();1')
        
        NetManager.ins.ajaxElementNew(function(success){
            console.log(DataManager.ins.ajaxElementDataNew);
            if(success && DataManager.ins.ajaxElementDataNew.code == '0000000000'){
                NetManager.ins.informationZhaohang((success) => {
                    if(success){    
                        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                    }else{
                        if(DataManager.ins.getInformationZhaohangData.code == 'E1002060003'){
                            SceneCtrl.instance.change(ModuleTypes.START_SCENE, true);
                        }else{
                            PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'获取场次信息失败，请刷新重试'});
                        }
                    }
                }, DataManager.ins.customCfgData.actId);
            }else{

                if(DataManager.ins.ajaxElementDataNew.code == 'E100201001' || DataManager.ins.ajaxElementDataNew.code == 'E100201002'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'您还未登录，请登录重试'});
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'请刷新重试'});
                }
                Loading.instace.hide();

                // console.log('errorCode:' + DataManager.ins.doJoinData.code);
                // PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'请刷新重试', line: 1});
                // PanelCtrl.instance.show(ModuleTypes.WARNING_PANEL, {idx:1});
                // Loading.instace.hide();
            }
        }.bind(this));

    }

    private onTap_shareBtn():void{
        PanelCtrl.instance.btnDelay(this.shareBtn);
        
        const startDpmOut = Buried.connectDpm(110, 10, 1); // 点击埋点   
        const startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        const exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        var param = {
			"shareTitle" : window['shareTitle'] ? window['shareTitle'] : '下载苏州银行APP 百万豪礼免费拿',// 标题
			"shareTextUrl" : window['shareTextUrl'] ? window['shareTextUrl'] : 'https://www.baidu.com',//window.basePath + '/page/conductBuy/cBuyMain.html',// 链接
			"shareText" : window['shareText'] ? window['shareText'] : '下载苏州银行APP 百万豪礼免费拿'// 分享文本内容
        };
        if(window['ThirdApp']){
            window['ThirdApp'].webviewShare(param);
        }

        // this.onTouchTap();
        this.hidePanel();

        Loading.instace.show();
        NetManager.ins.shareZhaohang((success) => {
            if(success && DataManager.ins.getShareZhaohangData.code == '0000000000'){
                setTimeout(() => {    
                    PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL, {type: 0});

                    Loading.instace.hide();
                }, 5000);
            }else{
                PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'分享失败了！'});
                Loading.instace.hide();
            }
        }, DataManager.ins.getInformationZhaohangData.data.scenes[0].scene, DataManager.ins.customCfgData.actId, 0);
    }

    private onLoad():void{
        if(this.mData){
            switch(this.mData.type){
                case 0:
                    this.titleLb.text = '';
                    this.titleLb.textColor = 0xffd416;

                    this.desLb.text = '您增加一次抢红包机会';

                    this.okBtn.visible = true;
                    this.shareBtn.visible = false;
                    this.iknowBtn.visible = false;
                    this.moreBtn.visible = false;

                    this.shareTipsLb.visible = false;

                    const startDpmOut = Buried.connectDpm(110, 8, 1); // 点击埋点   
                    const startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                    const exposure = Buried.createExposure(startDpmOut, startDcmOut);

                    NetManager.ins.showLog(exposure);
                break;
                case 1:
                    this.titleLb.text = '很遗憾';
                    this.titleLb.textColor = 0xffffff;
    
                    this.desLb.text = '您与红包擦肩而过';

                    
                    let idata = DataManager.ins.getInformationZhaohangData.data;
                    if(idata.ifCanAddJoinTimesByShare){
                        this.shareTipsLb.visible = true;

                        this.okBtn.visible = false;
                        this.shareBtn.visible = true;
                        this.iknowBtn.visible = false;
                        this.moreBtn.visible = false;

                        const startDpmOut = Buried.connectDpm(110, 10, 1); // 点击埋点   
                        const startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                        const exposure = Buried.createExposure(startDpmOut, startDcmOut);

                        NetManager.ins.showLog(exposure);

                        this.setPrizeResult(0);
                    }else{
                        if(idata.isNewActivityGuide){//最后一天显示更多游戏
                            this.shareTipsLb.visible = false;
    
                            this.okBtn.visible = false;
                            this.shareBtn.visible = false;
                            this.iknowBtn.visible = false;
                            this.moreBtn.visible = true;

                        }else{
                            this.shareTipsLb.visible = false;
    
                            this.okBtn.visible = false;
                            this.shareBtn.visible = false;
                            this.iknowBtn.visible = true;
                            this.moreBtn.visible = false;
    
                            const startDpmOut = Buried.connectDpm(110, 9, 1); // 点击埋点   
                            const startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                            const exposure = Buried.createExposure(startDpmOut, startDcmOut);
        
                            NetManager.ins.showLog(exposure);

                        }
                    }
                break;
                case 2:
                    this.titleLb.text = '您来晚了';
                    this.titleLb.textColor = 0xffffff;

                    this.desLb.text = '本轮已结束';

                    this.okBtn.visible = false;
                    this.moreBtn.visible = false;
                    this.shareBtn.visible = false;
                    this.iknowBtn.visible = true;
                    
                    this.shareTipsLb.visible = false;



                    const startDpmOut1 = Buried.connectDpm(110, 11, 1); // 点击埋点   
                    const startDcmOut1 = Buried.connectDcm(202, 0, 0); // 曝光埋点
                    const exposure1 = Buried.createExposure(startDpmOut1, startDcmOut1);

                    NetManager.ins.showLog(exposure1);
                break;
                case 3:
                    this.titleLb.text = '您来晚了';
                    this.titleLb.textColor = 0xffffff;
    
                    this.desLb.text = '本轮已结束';
    
                    this.okBtn.visible = false;
                    this.moreBtn.visible = true;
                    this.shareBtn.visible = false;
                    this.iknowBtn.visible = false;
                        
                    this.shareTipsLb.visible = false;

                break;
            }
        }

    }

    private onTap():void{
        PanelCtrl.instance.btnDelay(this.okBtn);


        const startDpmOut = Buried.connectDpm(110, 10, 1); // 点击埋点   
        const startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        const exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        const times = DataManager.ins.ajaxElementDataNew.element.freeLimit - 1;
        DataManager.ins.ajaxElementDataNew.element.freeLimit = times;

        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        this.hidePanel();
        
    }

    private onTap1():void{//立即再抢
        PanelCtrl.instance.btnDelay(this.okBtn);


        const startDpmOut = Buried.connectDpm(110, 8, 1); // 点击埋点   
        const startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        const exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        this.hidePanel();
        Loading.instace.show();
        NetManager.ins.informationZhaohang((success) => {
            if(success){
                let desTime = window['desTime'] ? window['desTime'] : 0;
                let idata = DataManager.ins.getInformationZhaohangData.data;
                let startTime = idata.scenes[0].startTime - idata.serverTime + desTime;
                let endTime = idata.scenes[0].endTime - idata.serverTime  - desTime;

                if(idata.todayTimesIsEnd){//今日场次已结束
                    if(idata.isNewActivityGuide){//如果是最后一天
                        PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL, {type:3});
                    }else{
                        PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL, {type:2});
                    }
                }else{
                    this.doJion();
                }

            }else{
                if(DataManager.ins.getInformationZhaohangData.code == 'E1002060003'){
                    SceneCtrl.instance.change(ModuleTypes.START_SCENE, true);
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'获取场次信息失败，请刷新重试'});
                }
            }

            Loading.instace.hide();
        }, DataManager.ins.customCfgData.actId);

        
    }

    onTouchTap():any{
        super.onTouchTap();
        if(this['closeBtn']){
            PanelCtrl.instance.btnDelay(this['closeBtn']);
        }
        
        const times = DataManager.ins.ajaxElementDataNew.element.freeLimit - 1;
        DataManager.ins.ajaxElementDataNew.element.freeLimit = times;

        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
        // this.hidePanel();
    }

    private doJion():void{

        let type = '';
        if(DataManager.ins.getInformationZhaohangData.data.joinTimesDetail && DataManager.ins.getInformationZhaohangData.data.joinTimesDetail.length){
            type = DataManager.ins.getInformationZhaohangData.data.joinTimesDetail[0].type;
        }else{
            type = '';
        }
        Loading.instace.show();
        PanelCtrl.instance.isLoseCoin = false;
        NetManager.ins.doJoinZhaohang(function(success: boolean){
            if(success && DataManager.ins.doJoinData.code == '0000000000'){
                NetManager.ins.getNgameStartStatus(function(data){
                    if (data == 'pollingFaild' || !data) {
                        //此时不能中奖
                        PanelCtrl.instance.isLoseCoin = true;
                        if(this.mData && this.mData.isstart){
                            SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
                        }else{
                            GDispatcher.dispatchEvent('restart');
                        }
                        return;
                    } else {
                        if(this.mData && this.mData.isstart){
                            SceneCtrl.instance.change(ModuleTypes.GAME_SCENE);
                        }else{
                            GDispatcher.dispatchEvent('restart');
                        }
                    }

                    Loading.instace.hide();
                }.bind(this), DataManager.ins.doJoinData.orderId, () => {
                    return !(DataManager.ins.getNgameStartStatusData.code == '0000000000');
                });
            }else{
                if(DataManager.ins.doJoinData){
                    console.log('errorCode:' + DataManager.ins.doJoinData.code);
                }
                if (DataManager.ins.doJoinData.code == 'E100202007' || DataManager.ins.doJoinData.code == 'E100202008' || DataManager.ins.doJoinData.code == 'E100202009' || DataManager.ins.doJoinData.code == 'E100202010'){  
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'已达到次数上限！', line: 1});
                    Loading.instace.hide();
                }else if(DataManager.ins.doJoinData.code == 'E100201007'){

                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'您的积分不足！'});
                    Loading.instace.hide();
                }else{//未中奖
                    PanelCtrl.instance.isLoseCoin = true;
                    Loading.instace.hide();
                    GDispatcher.dispatchEvent('restart');
                }
            }
        }.bind(this), type, DataManager.ins.getInformationZhaohangData.data.currentTimes);
    }

    //记录中奖结果
    //出奖结果：1：已中奖 0：未中奖
    private setPrizeResult(type:number):void{
        NetManager.ins.updateRecentJoinResult((success) => {
            if(success && DataManager.ins.getUpdateRecentJoinResultData.code == '0000000000'){
                console.log('中奖结果记录成功');
            }else{
                console.log('中奖结果记录失败');
            }
        }, DataManager.ins.getInformationZhaohangData.data.scenes[0].scene, DataManager.ins.customCfgData.actId, type);
    }
}