import { GCache } from './../libs/tc/util/GCache';
import { Buried } from './../libs/tw/util/Buried';

import layers from "./views/layers";
import { getResPath } from "./utils";
import AssetAdapter from "./AssetAdapter";
import ThemeAdapter from "./ThemeAdapter";
import { DataManager } from "../libs/tw/manager/DataManager";
import Loading from "./loading/Loading";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import { ModuleTypes } from './types/sceneTypes';
import { NetManager } from '../libs/tw/manager/NetManager';
import MsgPanel from './msgPanel/MsgPanel';
import GameScene from './gameScene/GameScene';
import PrizePanel from './prizePanel/PrizePanel';
import GuidePanel from './guidePanel/GuidePanel';
import GameOverPanel from './gameOverPanel/GameOverPanel';
import WarningPanel from './warningPanel/WarningPanel';
import StartScene from './startScene/StartScene';
import RulePanel from './rulePanel/RulePanel';
import RankPanel from './rankPanel/RankPanel';
import WaitingRankPanel from './waitingrankPanel/WaitingRankPanel';
import ToastPanel from './toastPanel/ToastPanel';
import TipsPanel from './tipsPanel/TipsPanel';
import OverPageScene from './overPageScene/OverPageScene';
import ResultScene from './resultScene/ResultScene';
import ResultPanel from './resultPanel/ResultPanel';
import DescribePanel from './describePanel/DescribePanel';
import TimesTipsPanel from './timesTipsPanel/TimesTipsPanel';

class Main extends eui.UILayer {
    protected createChildren(): void {
        super.createChildren();
        // alert(1)

        egret.lifecycle.addLifecycleListener((context) => {
            // custom lifecycle plugin
        })

        //遇到输入框注释掉这个代码
        // egret.lifecycle.onPause = () => {
        //     egret.ticker.pause();
        // }

        // egret.lifecycle.onResume = () => {
        //     egret.ticker.resume();
        // }

        //inject the custom material parser
        //注入自定义的素材解析器
        let assetAdapter = new AssetAdapter();
        egret.registerImplementation("eui.IAssetAdapter", assetAdapter);
        egret.registerImplementation("eui.IThemeAdapter", new ThemeAdapter());

        egret.ImageLoader.crossOrigin = "anonymous";

        // 老游戏
        // DataManager.ins.gameCfgData = window['CFG'];
        // DataManager.ins.gameCfgData.gameInfo.gameId = window['gameId'];

        //新游戏cfg
        DataManager.ins.customCfgData = window['CFG'];

        GCache.init([DataManager.ins.customCfgData.actId + '', DataManager.ins.customCfgData.consumerId + '']);

        layers.init(this);
        Loading.init(layers.topLayer);
        PanelCtrl.instance.init(layers.popupLayer);
        SceneCtrl.instance.init(layers.sceneLayer);
        // Buried.init();

        this.stage.scaleMode = egret.StageScaleMode.FIXED_WIDTH;

        SceneCtrl.instance.registerSceneClass(ModuleTypes.GAME_SCENE, GameScene);
        SceneCtrl.instance.registerSceneClass(ModuleTypes.START_SCENE, StartScene);

        PanelCtrl.instance.registerPanelClass(ModuleTypes.RULE_PANEL, RulePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.PRIZE_PANEL, PrizePanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.TOAST_PANEL, ToastPanel);
        PanelCtrl.instance.registerPanelClass(ModuleTypes.GAMEOVER_PANEL, GameOverPanel);

        this.runGame().catch(e => {
            console.log(e);
        })
    }

    private async runGame() {
        await this.loadResource()
        this.createGameScene();
        this.resErrorListener();
        // RES.loadGroup("msg", 10);
    }

    private resErrorListener(): void {
        //添加资源组加载失败事件
        // RES.addEventListener(RES.ResourceEvent.GROUP_LOAD_ERROR, this.onResourceError, this);
        // //添加资源加载失败事件
        // RES.addEventListener(RES.ResourceEvent.ITEM_LOAD_ERROR, this.onResourceError, this);
    }

    private onResourceError(): void {
        let msg = '请刷新重试';
        // if(PanelCtrl.instance.isLoseCoin){
        //     msg = '请联系客服找回积分';
        // }else{
        //     msg = '请刷新重试';
        // }
        // console.log('isLoadedMsg' + PanelCtrl.instance.isLoadedMsg);

        if (PanelCtrl.instance.isLoadedMsg) {

            PanelCtrl.instance.showMsg('okBtn', 4, null, null, msg);

        } else {
            alert('网络开小差了\n' + msg);
        }
    }

    private async loadResource() {
        try {
            // const loadingView = new LoadingUI();
            // this.stage.addChild(loadingView);
            await RES.loadConfig("default.res.json", getResPath() + "resource/");
            await this.loadTheme();
            // await RES.loadGroup("msg", 10);
            // this.stage.removeChild(loadingView);
        }
        catch (e) {
            console.error(e);
        }
    }

    private loadTheme() {
        return new Promise((resolve, reject) => {
            // load skin theme configuration file, you can manually modify the file. And replace the default skin.
            //加载皮肤主题配置文件,可以手动修改这个文件。替换默认皮肤。
            let theme = new eui.Theme("resource/default.thm.json", this.stage);
            theme.addEventListener(eui.UIEvent.COMPLETE, () => {
                resolve();
            }, this);

        })
    }

    /**
     * 创建场景界面
     * Create scene interface
     */
    protected createGameScene(): void {
        //获取游戏信息
        Loading.instace.show();

        NetManager.ins.ajaxElementNew(function(success){
            console.log(DataManager.ins.ajaxElementDataNew);
            if(success && DataManager.ins.ajaxElementDataNew.code == '0000000000'){
                Buried.init();
                NetManager.ins.informationZhaohang((success) => {
                    if(success){
                        SceneCtrl.instance.change(ModuleTypes.START_SCENE);
                    }else{
                        if(DataManager.ins.getInformationZhaohangData.code == 'E1002060003'){
                            SceneCtrl.instance.change(ModuleTypes.START_SCENE, true);
                        }else{
                            PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'获取场次信息失败，请刷新重试'});
                        }
                    }
                }, DataManager.ins.customCfgData.actId);
            }else{

                if(DataManager.ins.ajaxElementDataNew.code == 'E100201001' || DataManager.ins.ajaxElementDataNew.code == 'E100201002'){
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'您还未登录，请登录重试'});
                }else{
                    PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'请刷新重试'});
                }
                Loading.instace.hide();

                // console.log('errorCode:' + DataManager.ins.doJoinData.code);
                // PanelCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'请刷新重试', line: 1});
                // PanelCtrl.instance.show(ModuleTypes.WARNING_PANEL, {idx:1});
                // Loading.instace.hide();
            }
        }.bind(this));

    }
}

window['Main'] = Main;