import { NetManager } from './../../libs/tw/manager/NetManager';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";
import ToastCtrl from '../ctrls/toastCtrl';
import Waiting from '../waiting/Waiting';
import NetConst from '../NetConst';

export default class WarningPanel extends Panel {

    public get skinKey() { return "Warning" }

    public bg: eui.Image;
    public yesBtn: eui.Button;
    public noBtn: eui.Button;
    public closeBtn: eui.Button;
    public msgTxt: eui.Label;


    private _scene: any;
    start(scene) {
        this._scene = scene;
        NetManager.ins.showLog(this._scene.createExposure("jrgd"))

        // if (this._scene.guide) {
        //     this.yesBtn.horizontalCenter = 0;
        //     this.yesBtn.icon = `sureBtn_png`;
        //     this.noBtn.visible = false;
        //     this.closeBtn.visible = false;
        // }
    }

    initEvents() {
        super.initEvents();

        this.onTap(this.closeBtn, this.onTap_closeBtn);
        this.onTap(this.yesBtn, this.onTap_yesBtn);
        this.onTap(this.noBtn, this.onTap_closeBtn);
    }

    onTap_closeBtn() {

        this._scene.guide = false;
        this._scene.guideGroup1.visible = false;
        this.hidePanel();

    }

    onTap_yesBtn() {
        //  判断柴火是否足够
        NetManager.ins.clickLog(this._scene.createExposure("jrgd"))
        if (DataManager.ins.getData("getPetsInfo").data.foodNum < 25) {
            ToastCtrl.instance.show("柴火不足，先去攒柴火吧~")
            this._scene.guide = false;
            this._scene.guideGroup1.visible = false;
            this._scene.enableTap(true)
            this.hidePanel();
            return
        }
        // 调用heatSoup接口
        Waiting.instance.show();
        let petId = this._scene.currTargetSoupId;
        this._scene.enableTap(false);
        NetConst.heatSoup((s) => {
            if (!s) {
                ToastCtrl.instance.show("网络异常！加热失败，请重新尝试~");
                this._scene.guide = false;
                this._scene.guideGroup1.visible = false;
                Waiting.instance.hide();
                this._scene.enableTap(true)
                this.hidePanel();
                return
            }
            DataManager.ins.getData("getPetsInfo").data.foodNum = DataManager.ins.getData("heatSoup").data.foodNum;
            Waiting.instance.hide();
            this._scene.guide = false;
            this._scene.guideGroup1.visible = false;
            this._scene.fireWoodsTxt.text = DataManager.ins.getData("heatSoup").data.foodNum + "";
            let idx = this._scene.currTargetPotIdx;
            // this._scene.enableTap(true)
            this._scene.heatUp(idx)
            this.hidePanel();
        }, petId, window['CFG'].activityId)
    }

    removeEvents() {
        this.clearTap(this.closeBtn, this.onTap_closeBtn);
        this.clearTap(this.yesBtn, this.onTap_yesBtn);
        this.clearTap(this.noBtn, this.onTap_closeBtn);
    }
}