import { DataManager } from './../../libs/tw/manager/DataManager';
import { NetManager } from './../../libs/tw/manager/NetManager';
import Panel from "../views/Panel";

export default class SignPrizePanel extends Panel {
    public get skinKey() { return "DailySignPrize" }

    public bg: eui.Image;
    public sureBtn: eui.Button;
    public closeBtn: eui.Button;
    public title: eui.Image;
    public prizeBg: eui.Image;
    public prizeTxt: eui.Label;
    public tips: eui.Label;


    private _scene: any;

    constructor(scene) {
        super();
        this._scene = scene;

        NetManager.ins.showLog(this._scene.createExposure("mrqd"));
        // 周期内累积签到天数
        this.tips.text = `已连续签到${DataManager.ins.getData("doSign").signInfoVO.acmDays}日，\n 连续签到7日可获得额外奖励喔`
    }


    initEvents() {
        super.initEvents();
        this.onTap(this.sureBtn, this.onTouchTap);
    }

    onTouchTap() {
        super.onTouchTap();
        NetManager.ins.clickLog(this._scene.createExposure("mrqd"))
        this._scene.isGuide();
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.sureBtn, this.onTouchTap);
    }

}