import { NetManager } from './../../libs/tw/manager/NetManager';
import { SoupTypes } from './../mainScene/SoupTypes';
import Panel from "../views/Panel";

export default class CollectPotSucPanel extends Panel {
    public get skinKey() { return "CollectPotSuc" }


    public light: eui.Image;
    public bg: eui.Image;
    public sureBtn: eui.Button;
    public title: eui.Label;
    public closeBtn: eui.Button;
    public prizeImg: eui.Image;

    private _scene: any;

    constructor(data) {
        super();
        this._scene = data.scene;
        this.initUI(data.type);
        NetManager.ins.showLog(this._scene.createExposure("gdtc"))
        egret.Tween.get(this.light, { loop: true })
            .to({ rotation: 360 }, 5000)
    }

    initUI(data) {
        switch (data) {
            case SoupTypes.MUSHROOM:
                this.prizeImg.source = `mushroomDemo_png`;
                break;
            case SoupTypes.SPICY:
                this.prizeImg.source = `spicyDemo_png`;
                break;
            case SoupTypes.THREEFRESH:
                this.prizeImg.source = `threeFreshDemo_png`;
                break;
            case SoupTypes.TOMATO:
                this.prizeImg.source = `tomatoDemo_png`;
                break;
        }
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.sureBtn, this.onTouchTap)
    }

    onTouchTap() {
        super.onTouchTap();
        NetManager.ins.clickLog(this._scene.createExposure("gdtc"))
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.sureBtn, this.onTouchTap);
    }
}