import { SoupTypes } from './SoupTypes';
import Scene from "../views/Scene";
import ComponentBase from "../components/ComponentBase";
import { wait } from '../GameConst';

export default class Soup extends ComponentBase {

    public get skinKey() { return "Soup" }

public soupGroup0:eui.Group;
public soupBase0:eui.Image;
public mushroomEle0:eui.Image;
public mushroomEle1:eui.Image;
public mushroomEle2:eui.Image;
public mushroomEle3:eui.Image;
public mushroomEle4:eui.Image;
public mushroomEle5:eui.Image;
public soupGroup1:eui.Group;
public soupBase1:eui.Image;
public spicyEle0:eui.Image;
public spicyEle1:eui.Image;
public spicyEle2:eui.Image;
public spicyEle3:eui.Image;
public spicyEle4:eui.Image;
public spicyEle5:eui.Image;
public spicyEle6:eui.Image;
public spicyEle7:eui.Image;
public soupGroup2:eui.Group;
public soupBase2:eui.Image;
public threefreshEle0:eui.Image;
public threefreshEle1:eui.Image;
public threefreshEle10:eui.Image;
public threefreshEle11:eui.Image;
public threefreshEle12:eui.Image;
public threefreshEle2:eui.Image;
public threefreshEle3:eui.Image;
public threefreshEle4:eui.Image;
public threefreshEle5:eui.Image;
public threefreshEle6:eui.Image;
public threefreshEle7:eui.Image;
public threefreshEle8:eui.Image;
public threefreshEle9:eui.Image;
public soupGroup3:eui.Group;
public soupBase3:eui.Image;
public tomatoEle0:eui.Image;
public tomatoEle1:eui.Image;
public tomatoEle2:eui.Image;
public tomatoEle3:eui.Image;
public Thermometer:eui.ProgressBar;
public heatTips:eui.Image;
public collectTips:eui.Image;


    public type: SoupTypes;
    public idx: number;
    public status: number;

    constructor(type: SoupTypes) {
        super();
        this.type = type;
        this.initUI()
        // this.playAni();
    }

    private initUI() {
        switch (this.type) {
            case SoupTypes.MUSHROOM:
                this.soupGroup0.visible = true;
                this.soupGroup1.visible = false;
                this.soupGroup2.visible = false;
                this.soupGroup3.visible = false;
                break;
            case SoupTypes.SPICY:
                this.soupGroup0.visible = false;
                this.soupGroup1.visible = true;
                this.soupGroup2.visible = false;
                this.soupGroup3.visible = false;
                break;
            case SoupTypes.THREEFRESH:
                this.soupGroup0.visible = false;
                this.soupGroup1.visible = false;
                this.soupGroup2.visible = true;
                this.soupGroup3.visible = false;
                break;
            case SoupTypes.TOMATO:
                this.soupGroup0.visible = false;
                this.soupGroup1.visible = false;
                this.soupGroup2.visible = false;
                this.soupGroup3.visible = true;
                break;
        }
    }


    /**
     * 播放动画
     * @param t 温度
     */
    public playAni(te?) {
        let t = te ? te : 0;
        switch (this.type) {
            case SoupTypes.MUSHROOM:
                this.playMushroomAni(t);
                break;
            case SoupTypes.SPICY:
                this.playSpicyAni(t);
                break;
            case SoupTypes.THREEFRESH:
                this.playThreeFreshAni(t);
                break;
            case SoupTypes.TOMATO:
                this.playTomatoAni(t);
                break;
        }
    }

    playMushroomAni(t) {
        switch (t) {
            case "0":
                break;
            case "25":
                break;
            case "50":
                break;
            case "75":
                break;
            case "100":
                break;
        }

    }

    playSpicyAni(t) {
        switch (t) {
            case "0":
                break;
            case "25":
                break;
            case "50":
                break;
            case "75":
                break;
            case "100":
                break;
        }
    }

    playThreeFreshAni(t) {
        switch (t) {
            case "0":
                break;
            case "25":
                break;
            case "50":
                break;
            case "75":
                break;
            case "100":
                break;
        }
    }

    playTomatoAni(t) {
        switch (t) {
            case "0":
                break;
            case "25":
                break;
            case "50":
                break;
            case "75":
                break;
            case "100":
                break;
        }
    }
}