import { IExposureData } from './../../libs/tw/data/common/IExposureData';
import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import { CollectData } from './../../libs/tw/data/pet/CollectData';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Waiting from '../waiting/Waiting';
import NetConst from '../NetConst';
import ToastCtrl from '../ctrls/toastCtrl';
import PanelCtrl from '../ctrls/panelCtrl';
export default class Exchange {

    public get scene() { return this._scene }

    public get tomatoNum() { return this._scene.tomatoNum }
    public get threefreshNum() { return this._scene.threefreshNum }
    public get mushroomNum() { return this._scene.mushroomNum }
    public get spicyNum() { return this._scene.spicyNum };
    public get exchangeList() { return this._scene.exchangeList }

    private _scene: any;

    constructor(scene) {
        this._scene = scene;
    }

    private exchangePool: any[] = []

    /**
     * 更新汤底数量
     */
    isNoSoup = true;
    public updateSoupNum() {
        if (DataManager.ins.getData("getCollectRule").collectRule.length > 0) {
            for (let i = 0; i < DataManager.ins.getData("getCollectRule").collectGoods.length; i++) {
                let name = DataManager.ins.getData("getCollectRule").collectGoods[i].name;
                let num = DataManager.ins.getData("getCollectRule").collectGoods[i].count;
                if (num > 0 && this.isNoSoup) {
                    this.isNoSoup = false
                }
                switch (name) {
                    case "番茄锅":
                        this.tomatoNum.text = "X" + num;
                        if (num != 0) {
                            this._scene.tomatoNumBg.source = "soupNumBg1_png";
                        } else {
                            this._scene.tomatoNumBg.source = "soupNumBg0_png";
                        }
                        break;
                    case "三鲜锅":
                        this.threefreshNum.text = "X" + num;
                        if (num != 0) {
                            this._scene.threefreshNumBg.source = "soupNumBg1_png";
                        } else {
                            this._scene.threefreshNumBg.source = "soupNumBg0_png";
                        }
                        break;
                    case "菌菇锅":
                        this.mushroomNum.text = "X" + num;
                        if (num != 0) {
                            this._scene.mushroomNumBg.source = "soupNumBg1_png";
                        } else {
                            this._scene.mushroomNumBg.source = "soupNumBg0_png";
                        }
                        break;
                    case "清油麻辣锅":
                        this.spicyNum.text = "X" + num;
                        if (num != 0) {
                            this._scene.spicyNumBg.source = "soupNumBg1_png";
                        } else {
                            this._scene.spicyNumBg.source = "soupNumBg0_png";
                        }
                        break;
                }
            }
        }
    }

    /**
     * 更新兑换状态
     */
    updateExchangeStatus() {
        if (!DataManager.ins.getData("getCollectRule") && !DataManager.ins.getData("getCollectRule").CollectRule) {
            return
        }
        this.exchangePool = [];

        if (this.exchangeList && this.exchangeList.$children && this.exchangeList.$children.length > 0) {
            for (let i = this.exchangeList.$children.length - 1; i >= 0; i--) {
                this.exchangeList.removeChild(this.exchangeList.$children[i])
            }
        }

        // 今日兑换次数
        let todayOpenPrizeCount = DataManager.ins.getData("getCollectRule").todayOpenPrizeCount;

        if (DataManager.ins.getData("getCollectRule").collectRule.length > 4) {
            // 奖品列表
            for (let i = 4; i < DataManager.ins.getData("getCollectRule").collectRule.length; i++) {
                // 每个奖品列表
                let item = DataManager.ins.getData("getCollectRule").collectRule[i];
                if (item.grade > 4) {
                    let rules = item.rule;
                    let exchangeItem = new eui.Component()
                    this.exchangePool.push(exchangeItem);
                    exchangeItem.name = "exchangeItem_" + rules.grade;
                    exchangeItem.skinName = "ExchangeItemSkin";
                    exchangeItem.y = (i - 4) * 170;
                    console.log(this.exchangeList)
                    this.exchangeList.addChild(exchangeItem);
                    let isOpenPrize = false;
                    let openCount = 0;
                    exchangeItem['dishesImg'].mask = exchangeItem['prizeMask'];
                    let grade = item.grade;
                    window["exchangeConfig"].forEach(element => {
                        if (element.grade == grade) {
                            exchangeItem['prizeName'].text = element.name;
                            exchangeItem['dishesImg'].source = element.img;
                        }
                    });
                    if (rules.length > 0) {
                        for (let t = 0; t < rules.length; t++) {
                            const soup = rules[t];
                            let name = soup.name
                            let count = soup.count;
                            let needCount = soup.needCount;

                            let xb = 189;
                            let width = 360 / rules.length;
                            let ele = new eui.Component();
                            ele.x = xb + width * t;
                            ele.y = 60;
                            ele.width = width;
                            ele.height = 100;
                            ele.skinName = `SoupBaseSkin`;
                            exchangeItem.addChild(ele);
                            if (count >= needCount) {
                                openCount++;
                            }

                            switch (name) {
                                case "番茄锅":
                                    ele.name = "soup0";
                                    ele['soupImg'].source = `sSoup0_png`;
                                    ele['soupCount'].text = count + "/" + needCount;
                                    break;
                                case "三鲜锅":
                                    ele.name = "soup3"
                                    ele['soupImg'].source = `sSoup3_png`;
                                    ele['soupCount'].text = count + "/" + needCount;
                                    break;
                                case "菌菇锅":
                                    ele.name = "soup2"
                                    ele['soupImg'].source = `sSoup2_png`;
                                    ele['soupCount'].text = count + "/" + needCount;
                                    break;
                                case "清油麻辣锅":
                                    ele.name = "soup1"
                                    ele['soupImg'].source = `sSoup1_png`;
                                    ele['soupCount'].text = count + "/" + needCount;
                                    break;
                            }

                            if (0 < t) {
                                let add = new eui.Image();
                                add.source = `addIcon_png`;
                                add.anchorOffsetX = 5;
                                add.anchorOffsetY = 5;
                                add.x = xb + width * t;
                                add.y = 90;
                                add.width = 10;
                                add.height = 10;
                                if (rules.length == 3) {
                                    add.scaleX = 1.2;
                                    add.scaleY = 1.2;
                                } else if (rules.length == 2) {
                                    add.scaleX = 1.5;
                                    add.scaleY = 1.5;
                                }
                                exchangeItem.addChild(add);
                            }


                        }

                        exchangeItem['exchangeNowBtn'].grade = item.grade;
                    }
                    if (todayOpenPrizeCount > 0) {
                        exchangeItem['lackTips'].visible = false;
                        exchangeItem['exchangeNowBtn'].visible = false;
                        exchangeItem['exchangedTips'].visible = true;
                    } else {
                        if (openCount == rules.length) {
                            exchangeItem['lackTips'].visible = false;
                            exchangeItem['exchangeNowBtn'].visible = true;
                            NetManager.ins.showLog(this.createExposure(this.connectDpm(i - 3), this.connectDcm("cp1dh")))
                            exchangeItem['exchangeNowBtn'].i = i - 3;
                            exchangeItem['exchangeNowBtn'].addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_exchagneNowBtn.bind(this));
                        }
                    }
                }
            }
        }
    }

    public connectDpm(idx): string {
        return window['CFG'].appId + '.' + 39 + '.' + 10 + '.' + idx;
    }

    public connectDcm(name: string): string {
        return this._scene.exposure[`${name}`][1][0] + '.' + window['signActId'] + '.' + window['signSkinId'] + '.' + this._scene.exposure[`${name}`][1][1];
    }

    public createExposure(dpm, dcm, embedDomain = '//embedlog.duiba.com.cn'): IExposureData {
        const exposure: IExposureData = {
            dpm: dpm,
            dcm: dcm,
            consumerId: window['CFG'].consumerId,
            appId: window['CFG'].appId,
            domain: embedDomain
        };
        return exposure;
    }

    onTap_exchagneNowBtn(e) {
        let data = { scene: this._scene, e: e }
        NetManager.ins.clickLog(this.createExposure(this.connectDpm(e.$target.i), this.connectDcm("cp1dh")))
        PanelCtrl.instance.show(ModuleTypes.EXCHANGETIP_PANEL, data);
    }

    updateExchangeList() {
        if (!DataManager.ins.getData("getCollectRule") || !DataManager.ins.getData("getCollectRule").collectRule) {
            return
        }
        // 右边 我收获的锅底
        this.updateSoupNum();

        // 左边 可召唤的菜
        this.updateExchangeStatus();
    }

    hideExchange() {
        this._scene.isolatedLayer.visible = false;
        egret.Tween.get(this._scene.ExchangeGroup)
            .to({ y: 1800 }, 500)

    }

} 