import { SignInfoVo } from './../../libs/tw/data/pet/SignInfoVo';
import { NetManager } from './../../libs/tw/manager/NetManager';
import { ModuleTypes } from './../types/sceneTypes';
import { DataManager } from './../../libs/tw/manager/DataManager';
import NetConst from "../NetConst";
import Scene from "../views/Scene";
import ToastCtrl from '../ctrls/toastCtrl';
import Waiting from '../waiting/Waiting';

export default class DailyTask {
    private _scene: any;
    public get firstSign() { return this._scene.firstSignTask }
    public get dailySign() { return this._scene.dailySignTask };
    public get continueSign() { return this._scene.continueSignTask };
    public get consume() { return this._scene.consumeTask };
    public get exchange() { return this._scene.exchangeTask };

    constructor(scene) {
        this._scene = scene;

    }

    // 初始化任务状态
    public init() {
        // NetConst.daily
        if (DataManager.ins.getData("getSignInfo") && DataManager.ins.getData("getSignInfo").signInfoVO) {

        }
        if ((DataManager.ins.getData("getSignInfo").signInfoVO.acmDay == 1 && DataManager.ins.getData("getSignInfo").signInfoVO.todaySigned == true) || (DataManager.ins.getData("getSignInfo").signInfoVO.acmDay == 0 && DataManager.ins.getData("getSignInfo").signInfoVO.todaySigned == false)) {
            this.firstSign.visible = true;
            this.firstSign.taskNameTxt.text = "新手首次签到";
            this.firstSign.taskPrizeTxt.text = "可获得" + (window["firstSignPrize"] || "5柴火");
            this.dailySign.y = 120 - 11;
            this.continueSign.y = 120 + 111.5;
            this.consume.y = 120 + 233.5;
            this.exchange.y = 120 + 355;
        }

        this.dailySign.taskNameTxt.text = "每日签到";
        this.dailySign.taskPrizeTxt.text = "可获得" + (window['dailySignPrize'] || "20柴火");
        this.continueSign.taskNameTxt.text = "连续签到7日";
        this.continueSign.taskPrizeTxt.text = "可额外获得" + (window['acmSignPrize'] || "30柴火");


        this.consume.taskNameTxt.text = "堂食消费1次（每日限领1次）"
        // this.consume.taskPrizeTxt.text = "可获得" + (window['consumePrize'] || "50柴火");
        this.exchange.taskNameTxt.text = "捞币兑换1次（每日限领1次）"
        // this.exchange.taskPrizeTxt.text = "可获得" + (window['exchangePrize'] || "40柴火");
        this.update();

        this.initEvents()
    }

    // 更新任务状态
    private consumePrizeCredits: number = 50;
    private exchangePrizeCredits: number = 40;
    public update() {
        const todaySigned: boolean = DataManager.ins.getData("getSignInfo").signInfoVO.todaySigned;
        const acmDays: number = DataManager.ins.getData("getSignInfo").signInfoVO.acmDays;
        // const prizeChance: number = DataManager.ins.signInfoData.signInfoVO.pr
        if (todaySigned) {
            this.firstSign.goFinishBtn.visible = false;
            this.firstSign.goReceiveBtn.visible = false;
            this.firstSign.hasGetBtn.visible = true;
            this.dailySign.goFinishBtn.visible = false;
            this.dailySign.goReceiveBtn.visible = false;
            this.dailySign.hasGetBtn.visible = true;
            this.dailySign.taskMsg.visible = false;
        }

        if (acmDays) {
            if (acmDays == 0) {
                this.continueSign.goFinishBtn.visible = true;
                this.continueSign.goReceiveBtn.visible = false;
                this.continueSign.hasGetBtn.visible = false;
                this.continueSign.taskMsg.visible = false;
            } else if (acmDays < 7 && acmDays > 0) {
                this.continueSign.goFinishBtn.visible = false;
                this.continueSign.goReceiveBtn.visible = false;
                this.continueSign.hasGetBtn.visible = false;
                this.continueSign.taskMsg.visible = true;
                this.continueSign.taskMsg.text = `${acmDays}/7`;
            } else {
                // 7天时判断是否已经领奖
                // if () {
                this.continueSign.goFinishBtn.visible = false;
                this.continueSign.goReceiveBtn.visible = false;
                this.continueSign.hasGetBtn.visible = true;
                this.continueSign.taskMsg.visible = false;
                // } else {
                //     this.continueSign.goFinishBtn.visible = false;
                //     this.continueSign.goReceiveBtn.visible = true;
                //     this.continueSign.hasGetBtn.visible = false;
                //     this.continueSign.taskMsg.visible = false;
                // }

            }

        }

        if (DataManager.ins.getData("taskList") && DataManager.ins.getData("taskList").data && DataManager.ins.getData("taskList").data.length > 0) {
            for (let i = 0; i < DataManager.ins.getData("taskList").data.length; i++) {
                let task = DataManager.ins.getData("taskList").data[i];

                this.doConsumeUrl = window["doConsumeUrl"];
                this.doExchangeUrl = window["doExchangeUrl"];
                if (task.taskname && task.taskname.indexOf("消费") >= 0) {
                    this.consume['taskPrizeTxt'].text = `可获得${task.credits || 50}柴火`;
                    this.consumeTaskId = task.taskid;
                    this.consumePrizeCredits = task.credits || 50;
                    switch (task.status) {
                        case "success":
                            this.consume['goFinishBtn'].visible = false;
                            this.consume['goReceiveBtn'].visible = false;
                            this.consume['waitFinishTips'].visible = false;
                            this.consume['hasGetBtn'].visible = true;
                            break;
                        case "false":
                            NetManager.ins.showLog(this._scene.createExposure("xfqwc"))
                            this.consume['goFinishBtn'].visible = false;
                            this.consume['goReceiveBtn'].visible = false;
                            this.consume['waitFinishTips'].visible = true;
                            this.consume['hasGetBtn'].visible = false;
                            break;
                        case "process":
                            NetManager.ins.showLog(this._scene.createExposure("xfklq"))
                            this.consume['goFinishBtn'].visible = false;
                            this.consume['waitFinishTips'].visible = false;
                            this.consume['goReceiveBtn'].visible = true;
                            this.consume['hasGetBtn'].visible = false;
                            break;
                    }
                } else if (task.taskname && task.taskname.indexOf("捞币兑换") >= 0) {
                    this.exchange['taskPrizeTxt'].text = `可获得${task.credits || 40}柴火`;
                    this.exchangePrizeCredits = task.credits || 40;
                    this.exchangeTaskId = task.taskid;
                    switch (task.status) {
                        case "success":
                            this.exchange['goFinishBtn'].visible = false;
                            this.exchange['goReceiveBtn'].visible = false;
                            this.exchange['hasGetBtn'].visible = true;
                            break;
                        case "false":
                            NetManager.ins.showLog(this._scene.createExposure("dhqwc"))
                            this.exchange['goFinishBtn'].visible = true;
                            this.exchange['goReceiveBtn'].visible = false;
                            this.exchange['hasGetBtn'].visible = false;
                            break;
                        case "process":
                            NetManager.ins.showLog(this._scene.createExposure("dhklq"))
                            this.exchange['goFinishBtn'].visible = false;
                            this.exchange['goReceiveBtn'].visible = true;
                            this.exchange['hasGetBtn'].visible = false;
                            break;
                    }
                }
            }
        }

    }


    initEvents() {
        this.firstSign.goFinishBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.resign.bind(this))
        this.dailySign.goFinishBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.resign.bind(this))
        this.continueSign.goFinishBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.resign.bind(this))
        // this.consume.goFinishBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_doConsume.bind(this));
        this.consume.goReceiveBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_getConsumePrize.bind(this));
        this.exchange.goFinishBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_doExchange.bind(this));
        this.exchange.goReceiveBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_getExchangePrize.bind(this));
    }

    resign() {
        this._scene.dailySign(true);
        this._scene.isolatedLayer.visible = false;
        egret.Tween.get(this._scene.TaskGroup)
            .to({ y: 1800 }, 400)
    }

    public doConsumeUrl: string = window["doConsumeUrl"];
    public consumeTaskId: number = null;
    onTap_doConsume() {
        NetManager.ins.clickLog(this._scene.createExposure("xfqwc"))
        if (this.doConsumeUrl) {
            window.location.href = this.doConsumeUrl;
        } else {
            ToastCtrl.instance.show("任务正在赶来的路上~")
        }
        this.hideTask();
    }


    onTap_getConsumePrize() {
        Waiting.instance.show();
        NetManager.ins.clickLog(this._scene.createExposure("xfklq"))
        NetConst.takePrize((s) => {
            Waiting.instance.hide();
            if (!s) {
                // 容错
                ToastCtrl.instance.show("网络异常，请退出刷新再试，如有疑问，请联系捞小秘~");
                return
            }
            this.hideTask();
            // 出奖
            DataManager.ins.getData("getPetsInfo").data.foodNum = DataManager.ins.getData("takePrize").data.foodNum;
            ToastCtrl.instance.show(`成功领取${this.consumePrizeCredits}柴火`);
            this._scene.updateCredits();

            NetConst.taskList((s) => {
                // 更新失败暂时把按钮变为已完成
                this.consume.goReceiveBtn.visible = false;
                this.consume.hasGetBtn.visible = true;
                // this.update();
            }, window['CFG'].activityId)
        }, this.consumeTaskId, window['CFG'].activityId)
    }

    public doExchangeUrl: string = window["doExchangeUrl"];
    public exchangeTaskId: number = null;
    onTap_doExchange() {
        NetManager.ins.clickLog(this._scene.createExposure("dhqwc"))
        if (this.doExchangeUrl) {
            window.location.href = this.doExchangeUrl;
        } else {
            ToastCtrl.instance.show("任务正在赶来的路上~")
        }
        this.hideTask();
    }

    onTap_getExchangePrize() {
        Waiting.instance.show();
        NetManager.ins.clickLog(this._scene.createExposure("dhklq"))
        NetConst.takePrize((s) => {
            Waiting.instance.hide();
            if (!s) {
                // 容错
                ToastCtrl.instance.show("网络异常，请退出刷新再试，如有疑问，请联系捞小秘~");
                return
            }
            this.hideTask();
            // 出奖
            DataManager.ins.getData("getPetsInfo").data.foodNum = DataManager.ins.getData("takePrize").data.foodNum;
            ToastCtrl.instance.show(`成功领取${this.exchangePrizeCredits}柴火`);
            this._scene.updateCredits();

            NetConst.taskList((s) => {
                // 更新失败暂时把按钮变为已完成
                this.exchange.goReceiveBtn.visible = false;
                this.exchange.hasGetBtn.visible = true;
                // this.update();
            }, window['CFG'].activityId)
        }, this.exchangeTaskId, window['CFG'].activityId)
    }

    hideTask() {
        this._scene.isolatedLayer.visible = false;
        egret.Tween.get(this._scene.TaskGroup)
            .to({ y: 1800 }, 400)
    }
}