import { ModuleTypes } from './../types/sceneTypes';
import { NetManager } from './../../libs/tw/manager/NetManager';
import { DataManager } from './../../libs/tw/manager/DataManager';
import Panel from "../views/Panel";
import Waiting from "../waiting/Waiting";
import NetConst from "../NetConst";
import ToastCtrl from "../ctrls/toastCtrl";
import PanelCtrl from '../ctrls/panelCtrl';

export default class ExchangeTipPanel extends Panel {
    public get skinKey() { return "ExchangeTip" }

    public bg: eui.Image;
    public yesBtn: eui.Button;
    public noBtn: eui.Button;
    public mushroom: eui.Image;
    public spicy: eui.Image;
    public threeFresh: eui.Image;
    public tomato: eui.Image;
    public closeBtn: eui.Button;
    public tomatoNum: eui.Label;
    public spicyNum: eui.Label;
    public mushroomNum: eui.Label;
    public threefreshNum: eui.Label;
    public title: eui.Label;


    _scene: any;
    grade: any;
    constructor(data) {
        super();
        this._scene = data.scene;
        this.grade = data.e.$target.grade;
        this.log(this.grade)
    }

    start() {
        super.start();
        this.initUI();
    }


    initUI() {
        window['exchangeConfig'].forEach(item => {
            if (item.grade == this.grade) {
                this.title.text = `是否消耗下列锅底兑换${item.name}`
            }
        });
        for (let i = 4; i < DataManager.ins.getData("getCollectRule").collectRule.length; i++) {
            // 每个奖品列表
            let collectRule = DataManager.ins.getData("getCollectRule").collectRule[i];
            if (this.grade == collectRule.grade) {
                let rules = collectRule.rule;

                if (rules.length > 0) {
                    for (let t = 0; t < rules.length; t++) {
                        const soup = rules[t];
                        let name = soup.name;
                        let needCount = soup.needCount;

                        let xb = 150;
                        let width = 450 / rules.length;

                        let ele;

                        switch (name) {
                            case "番茄锅":
                                ele = this.tomato;
                                this.tomatoNum.text = needCount;
                                break;
                            case "三鲜锅":
                                ele = this.threeFresh;
                                this.threefreshNum.text = needCount;
                                break;
                            case "菌菇锅":
                                ele = this.mushroom;
                                this.mushroomNum.text = needCount;
                                break;
                            case "清油麻辣锅":
                                ele = this.spicy;
                                this.spicyNum.text = needCount;
                                break;
                        }
                        ele.width = width;
                        ele.visible = true;
                        ele.x = xb + width * t;
                    }
                }
            }
        }
    }

    initEvents() {
        super.initEvents();
        this.onTap(this.yesBtn, this.onTap_yesBtn);
        this.onTap(this.noBtn, this.onTouchTap);
    }

    onTap_yesBtn() {
        Waiting.instance.show();
        NetConst.openCollectGoodsPrize((s) => {
            if (!s) {
                Waiting.instance.hide();
                ToastCtrl.instance.show("兑换奖品异常，请联系捞小秘~", 3000);
                return
            }
            let orderId = DataManager.ins.getData("openCollectGoodsPrize").orderNum;
            NetManager.ins.getPlugOrderStatus((ss) => {
                if (!ss) {
                    Waiting.instance.hide();
                    // PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL);
                    ToastCtrl.instance.show("兑换奖品异常，请联系捞小秘~", 3000);
                    this.hidePanel();
                    this.hideExchange();
                    return
                }
                Waiting.instance.hide();
                this.hideExchange()
                this.hidePanel();
                let lottery = DataManager.ins.getPlugOrderStatusData.lottery
                if (lottery) {
                    let data = { scene: this._scene, lottery: lottery }
                    PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL, data)
                } else {
                    ToastCtrl.instance.show("兑换奖品异常，请联系捞小秘~", 3000);
                }
            }, orderId, () => { return DataManager.ins.getPlugOrderStatusData.result == 0 }, 10)
        }, window["collectRuleId"], this.grade)
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.yesBtn, this.onTap_yesBtn);
        this.clearTap(this.noBtn, this.onTouchTap);
    }

    hideExchange() {
        this._scene.isolatedLayer.visible = false;
        egret.Tween.get(this._scene.ExchangeGroup)
            .to({ y: 1800 }, 500)

    }
}