import { ModuleTypes } from './../types/sceneTypes';
import { getResPath } from './../utils';
import { NetManager } from './../../libs/tw/manager/NetManager';
import { DataManager } from './../../libs/tw/manager/DataManager';
import { SoupTypes } from './../mainScene/SoupTypes';
import Panel from '../views/Panel';
import NetConst from '../NetConst';
import ToastCtrl from '../ctrls/toastCtrl';
import Waiting from '../waiting/Waiting';
import PanelCtrl from '../ctrls/panelCtrl';
export default class ConsumePanel extends Panel {
    public get skinKey() { return "Consume" }

    public bg: eui.Image;
    public mushroom: eui.Image;
    public spicy: eui.Image;
    public threeFresh: eui.Image;
    public tomato: eui.Image;
    public closeBtn: eui.Button;
    public sureBtn: eui.Button;
    public adoptTips: eui.Image;
    public spicyMask: eui.Rect;
    public tomatoMask: eui.Rect;
    public mushroomMask: eui.Rect;
    public threefreshMask: eui.Rect;
    public tomatoNum: eui.Label;
    public spicyNum: eui.Label;
    public mushroomNum: eui.Label;
    public threefreshNum: eui.Label;

    private currTargetSoupType: SoupTypes = null;
    private _scene: any;
    constructor(scene) {
        super()
        this._scene = scene;

    }

    start() {
        super.start();
        this.initUI();
        NetManager.ins.showLog(this._scene.createExposure("cjxhgd"))
    }

    tomatoCount: number = 0;
    threefreshCount: number = 0;
    mushroomCount: number = 0;
    spicyCount: number = 0;
    initUI() {
        let isFocus = false;
        for (let i = 0; i < DataManager.ins.getData("getCollectRule").collectGoods.length; i++) {
            let soup = DataManager.ins.getData("getCollectRule").collectGoods[i];
            let name = soup.name;
            let count = soup.count;
            switch (name) {
                case "番茄锅":
                    this.tomatoNum.text = "X" + count;
                    this.tomatoCount = count;
                    if (count != 0) {
                        this.tomatoMask.visible = false;
                        this.onTap(this.tomato, this.onTap_tomato);
                        isFocus = true;
                    }
                    break;
                case "三鲜锅":
                    this.threefreshNum.text = "X" + count;
                    this.threefreshCount = count;
                    if (count != 0) {
                        this.threefreshMask.visible = false;
                        this.onTap(this.threeFresh, this.onTap_threeFresh);
                        isFocus = true;
                    }
                    break;
                case "菌菇锅":
                    this.mushroomNum.text = "X" + count;
                    this.mushroomCount = count;
                    if (count != 0) {
                        this.mushroomMask.visible = false;
                        this.onTap(this.mushroom, this.onTap_mushroom);
                        isFocus = true;
                    }
                    break;
                case "清油麻辣锅":
                    this.spicyNum.text = "X" + count;
                    this.spicyCount = count;
                    if (count != 0) {
                        this.spicyMask.visible = false;
                        this.onTap(this.spicy, this.onTap_spicy);
                        isFocus = true;
                    }
                    break;
            }


            this.adoptTips.visible = isFocus;
        }
        if (this.tomatoCount > 0) {
            this.onTap_tomato();
        } else if (this.spicyCount > 0) {
            this.onTap_spicy();
        } else if (this.mushroomCount > 0) {
            this.onTap_mushroom();
        } else if (this.threefreshCount > 0) {
            this.onTap_threeFresh();
        }
    }


    initEvents() {
        super.initEvents();
        this.onTap(this.sureBtn, this.onTap_sureBtn);
    }

    onTap_tomato() {

        this.currTargetSoupType = 1;
        this.adoptTips.x = this.tomato.x;
        this.adoptTips.y = this.tomato.y;
    }

    onTap_spicy() {
        this.currTargetSoupType = 2;
        this.adoptTips.x = this.spicy.x;
        this.adoptTips.y = this.spicy.y;
    }

    onTap_mushroom() {
        this.currTargetSoupType = 3;
        this.adoptTips.x = this.mushroom.x;
        this.adoptTips.y = this.mushroom.y;
    }

    onTap_threeFresh() {
        this.currTargetSoupType = 4;
        this.adoptTips.x = this.threeFresh.x;
        this.adoptTips.y = this.threeFresh.y;
    }

    onTap_sureBtn() {
        NetManager.ins.clickLog(this._scene.createExposure("cjxhgd"))
        Waiting.instance.show();
        let grade = this.currTargetSoupType;
        NetConst.openCollectGoodsPrize((s) => {
            if (!s) {
                Waiting.instance.hide();
                ToastCtrl.instance.show("抽取奖品异常，请联系捞小秘~", 3000);
                return
            }
            let orderId = DataManager.ins.getData("openCollectGoodsPrize").orderNum;
            // NetManager.ins.
            NetManager.ins.getPlugOrderStatus((ss) => {
                if (!ss) {
                    Waiting.instance.hide();
                    // 失败转谢谢参与
                    PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL);

                    this.hideExchange();
                    this.hidePanel()
                    return
                }
                Waiting.instance.hide();
                this.hideExchange();
                this.hidePanel()
                let lottery = DataManager.ins.getPlugOrderStatusData.lottery
                if (lottery) {
                    if (DataManager.ins.getPlugOrderStatusData.isError) {
                        // 降级谢谢参与
                        ToastCtrl.instance.show("抽奖异常，请退出刷新再试，\n如有疑问，请联系捞小秘~", 3000)
                    } else {
                        let data = { scene: this._scene, lottery: lottery }
                        PanelCtrl.instance.show(ModuleTypes.PRIZE_PANEL, data)
                    }
                } else {
                    // 没奖
                    if (DataManager.ins.getPlugOrderStatusData.isError) {
                        // 降级谢谢参与
                        ToastCtrl.instance.show("抽奖异常，请退出刷新再试，\n如有疑问，请联系捞小秘~", 3000)
                    } else {
                        // 正常谢谢参与
                        PanelCtrl.instance.show(ModuleTypes.NOPRIZE_PANEL);
                    }
                }
            }, orderId, () => { return DataManager.ins.getPlugOrderStatusData.result == 0 }, 10)
        }, window["collectRuleId"], grade)
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.tomato, this.onTap_tomato);
        this.clearTap(this.spicy, this.onTap_spicy);
        this.clearTap(this.mushroom, this.onTap_mushroom);
        this.clearTap(this.threeFresh, this.onTap_threeFresh);
        this.clearTap(this.sureBtn, this.onTap_sureBtn)
    }

    hideExchange() {
        this._scene.isolatedLayer.visible = false;
        egret.Tween.get(this._scene.ExchangeGroup)
            .to({ y: 1800 }, 500)
    }
}