import { NetName } from './../../libs/tw/enum/NetName';
import { NetManager } from './../../libs/tw/manager/NetManager';
import { DataManager } from './../../libs/tw/manager/DataManager';
import { SoupTypes } from './../mainScene/SoupTypes';
import Panel from "../views/Panel";
import ToastCtrl from '../ctrls/toastCtrl';
import Waiting from '../waiting/Waiting';
import NetConst from '../NetConst';
import GameConst from '../GameConst';
export default class AdoptSoupPanel extends Panel {
    get skinKey() { return "AdoptSoup" }

    public bg: eui.Image;
    public mushroom: eui.Image;
    public spicy: eui.Image;
    public threeFresh: eui.Image;
    public tomato: eui.Image;
    public closeBtn: eui.Button;
    public sureBtn: eui.Button;
    public costTxt: eui.Label;
    public adoptTips: eui.Image;

    private currTargetSoupType: SoupTypes = SoupTypes.TOMATO;
    private currSoupName: string = "番茄锅";
    private currSoupId: number = 0;
    private _scene: any;
    private idx: number;
    constructor(data) {
        super()
        this._scene = data.scene;
        this.idx = data.idx;
        this.onTap_tomato()
        NetManager.ins.showLog(this._scene.createExposure("xhgd"))
        // if (this._scene.guide) {
        //     this.closeBtn.visible = false;
        // }
    }




    initEvents() {
        super.initEvents();
        this.onTap(this.tomato, this.onTap_tomato);
        this.onTap(this.spicy, this.onTap_spicy);
        this.onTap(this.mushroom, this.onTap_mushroom);
        this.onTap(this.threeFresh, this.onTap_threeFresh);
        this.onTap(this.sureBtn, this.onTap_sureBtn);
    }

    onTouchTap() {
        this._scene.enableTap(true)
        this._scene.guide = false;
        this._scene.guideGroup0.visible = false;
        super.onTouchTap();
    }

    onTap_tomato() {
        this.currSoupName = "番茄锅";
        DataManager.ins.getData("getPetsConfig").data.configs.forEach(config => {
            if (config.petName.indexOf("番茄锅") >= 0) {
                this.currSoupId = config.id;
            }
        });

        this.currTargetSoupType = SoupTypes.TOMATO;
        this.adoptTips.x = this.tomato.x;
        this.adoptTips.y = this.tomato.y;
    }

    onTap_spicy() {
        this.currSoupName = "清油麻辣锅";
        DataManager.ins.getData("getPetsConfig").data.configs.forEach(config => {
            if (config.petName.indexOf("清油麻辣锅") >= 0) {
                this.currSoupId = config.id;
            }
        });
        this.currTargetSoupType = SoupTypes.SPICY;
        this.adoptTips.x = this.spicy.x;
        this.adoptTips.y = this.spicy.y;
    }

    onTap_mushroom() {
        this.currSoupName = "菌菇锅";
        DataManager.ins.getData("getPetsConfig").data.configs.forEach(config => {
            if (config.petName.indexOf("菌菇锅") >= 0) {
                this.currSoupId = config.id;
            }
        });
        this.currTargetSoupType = SoupTypes.MUSHROOM;
        this.adoptTips.x = this.mushroom.x;
        this.adoptTips.y = this.mushroom.y;
    }

    onTap_threeFresh() {
        this.currSoupName = "三鲜锅";
        DataManager.ins.getData("getPetsConfig").data.configs.forEach(config => {
            if (config.petName.indexOf("三鲜锅") >= 0) {
                this.currSoupId = config.id;
            }
        });
        this.currTargetSoupType = SoupTypes.THREEFRESH;
        this.adoptTips.x = this.threeFresh.x;
        this.adoptTips.y = this.threeFresh.y;
    }

    // onTouchTap() {
    //     super.onTouchTap();
    // }

    onTap_sureBtn() {
        // 判断捞币
        NetManager.ins.clickLog(this._scene.createExposure("xhgd"))
        if (DataManager.ins.getData("getSignInfo").credits < 5) {
            ToastCtrl.instance.show("捞币不足，先去赚取捞币吧~");
            this._scene.guideGroup0.visible = false;
            this.hidePanel();
            return
        }
        // 领养接口
        this._scene.enableTap(false);
        Waiting.instance.show()
        let idx = this._scene.currTargetPotIdx + 1;
        console.log(this._scene.currTargetPotIdx, idx)
        let petIdentifier = "haidilao_0" + idx;
        NetConst.petAdopte((s) => {
            if (!s) {
                ToastCtrl.instance.show("网络异常！扣除捞币失败，请重试~");
                Waiting.instance.hide();
                this._scene.guideGroup0.visible = false;
                this._scene.enableTap(true);
                this.hidePanel();
                return
            }
            NetConst.answer(
                (ss) => {
                    if (!ss) {
                        ToastCtrl.instance.show("网络异常，添加锅底失败，请退出刷新再试。如有疑问，请联系捞小秘~");
                        Waiting.instance.hide();
                        this._scene.guideGroup0.visible = false;
                        this._scene.guide = false;
                        this._scene.enableTap(true);
                        this.hidePanel();
                        return
                    }
                    Waiting.instance.hide();
                    this._scene.guideGroup0.visible = false;
                    this._scene.currTargetSoupType = this.currTargetSoupType;
                    this._scene.addSoup(idx - 1);
                    this.hidePanel();
                    NetConst.getPetsInfo((sss) => {
                        if (!sss) {
                            ToastCtrl.instance.show("网络异常，更新锅底信息失败，请退出刷新再试。如有疑问，请联系捞小秘~");
                            return
                        }
                        this._scene.updateSoupIds();
                    }, window['CFG'].activityId)
                    NetConst.getSignInfo((sss) => {
                        if (!sss) {
                            ToastCtrl.instance.show("网络异常，更新捞币失败,请退出刷新再试。如有疑问，请联系捞小秘~")
                            return
                        }
                        this._scene.updateCredits();
                    }, window['signActId'])
                },
                1,
                DataManager.ins.getData("adopte").data.orderNum,
                () => {
                    return DataManager.ins.getData("answer").data.result !== 4
                })
        }, window['CFG'].activityId, this.currSoupName, petIdentifier, this.currSoupId)
    }

    removeEvents() {
        super.removeEvents();
        this.clearTap(this.tomato, this.onTap_tomato);
        this.clearTap(this.spicy, this.onTap_spicy);
        this.clearTap(this.mushroom, this.onTap_mushroom);
        this.clearTap(this.threeFresh, this.onTap_threeFresh);
        this.clearTap(this.sureBtn, this.onTap_sureBtn)
    }




}