
import { NetManager } from './../libs/tw/manager/NetManager';
import { DataManager } from './../libs/tw/manager/DataManager';
import { INetData } from './../libs/tc/interface/INetData';
/**
 * 接口常量
 * 
 * 普通游戏接口
 * hdtool/recon/ajaxElement
 * hdtool/recon/doJoin
 * hdtool/recon/ngame/getNgameStartStatus 游戏开始状态
 * hdtool/recon/ngame/ngameSubmit
 * hdtool/recon/getOrderStatus
 *
 * 游戏支持复活 调用接口说明
 * hdtool/recon/ajaxElement
 * hdtool/recon/doJoin
 * hdtool/recon/ngame/getNgameStartStatus 游戏开始状态
 * hdtool/recon/ngame/resurrectionStatus 复活状态 参数dojion中orderId
 *
 * 复活流程
 * hdtool/recon/ngame/resurrection 游戏复活接口 参数dojion中orderId 返回 复活id
 * hdtool/recon/ngame/resurrectionStatus 复活状态 参数dojion中orderId，复活id 返回 复活状态 剩余复活次数 下一次复活所需积分（轮询）
 *
 * 多次领奖流程
 * hdtool/recon/ngame/ngameManySubmit 游戏多次发奖接口 参数dojion中orderId 返回多次领奖orderId
 * hdtool/recon/getOrderStatus 参数多次领奖返回的orderId
 */
export default class NetConst {

    public static ajaxElement(callback) {
        const net: INetData = {
            name: 'gameAjaxElement',
            uri: '/hdtool/recon/ajaxElement',
            type: 'get',
            dataType: 'json',
            param: {
                duibaId: DataManager.ins.customCfgData.hdToolId,
                activityId: DataManager.ins.customCfgData.actId
            },
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 获取兑换记录
     * @param callback 
     * @param origins 来源，多个来源用,分隔，插件末尾补01，活动末尾补00，开心码末尾补02，集卡末尾补03  123401,123456700
     */
    public static getrecord(callback: Function, origins: string, page: number = 1) {
        const net: INetData = {
            name: "getrecord",
            uri: '/crecord/getrecord',
            type: 'get',
            dataType: 'json',
            param: {
                page: page,
                origins: origins
            },
            callback: callback,
            hideMsg: true   //用taost提示
        };
        NetManager.ins.send(net);
    }

    /**
     * 获取排行榜列表
     * @param callback 回调
     * @param rankId 排行榜id
     * @param hdtoolId 活动工具id
     */
    public static getRankList(callback: Function, rankId: any, hdtoolId: any): void {
        const param: any = {
            rankId: rankId,
            hdtoolId: hdtoolId
        };
        const net: INetData = {
            name: 'rankList',
            uri: '/hdtool/rank/rankList',
            type: 'get',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager.ins.send(net);
    }


    /**
     * 获取排行榜列表
     * @param callback 回调
     * @param rankId 排行榜id
     * @param activityId cfg oaid
     * @param needPreviousPeriod 是否需要上期排行榜数据
     * @param pageNo 
     * @param pageSize
     */
    public static recentRankList(callback: Function, rankId: number, activityId: number, needPreviousPeriod: boolean = false, pageNo: number = 0, pageSize: number = 50): void {
        const param: any = {
            rankId: rankId,
            activityId: activityId,
            needPreviousPeriod: needPreviousPeriod,
            pageNo: pageNo,
            pageSize: pageSize
        };
        const net: INetData = {
            name: 'recentRankList',
            uri: '/hdtool/rank/recentRankListNew',
            type: 'get',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager.ins.send(net);
    }


    /**
     * 参与游戏
     * @param callback 回调 
     * @param credits 积分
     * @param collectRuleId 集卡规则id？
     */
    public static doJoin(callback: Function, activityId = DataManager.ins.customCfgData.actId, credits?: number, collectRuleId?: number): void {
        const param: any = {
            activityId: activityId,
            activityType: 'hdtool',
            consumerId: DataManager.ins.customCfgData.consumerId
        };
        if (credits) {
            param.credits = credits;
        }
        if (collectRuleId) {
            param.collectRuleId = collectRuleId;
        }
        const net: INetData = {
            name: 'doJoin',
            uri: '/hdtool/recon/doJoin',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager.ins.getToken(net);
    }

    /**
     * 轮询开始状态
     * @param callback 回调
     * @param orderId 订单id
     */
    public static getNgameStartStatus(callback: Function, orderId: number, pollingCheck: Function, pollingCount = 10): void {
        const param: any = {
            orderId: orderId
        };
        const net: INetData = {
            name: 'getNgameStartStatus',
            uri: '/hdtool/recon/ngame/getNgameStartStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        NetManager.ins.send(net);
    }

    /**
     * 发送得分
     * @param callback 回调 
     * @param orderId 订单id
     * @param score 分数
     * @param gameData 游戏数据
     * @param dynamicData 动态数据
     * @param submitToken 提交数据token  由 getNgameStartStatus 返回
     */
    public static ngameSubmit(callback: Function, orderId: number, score: number, gameData: any, dynamicData: any, submitToken: string, rankId?: number): void {
        const sign = NetManager.ins['createSgin'](orderId, score, gameData, submitToken);
        const param: any = {
            orderId: orderId,
            score: score,
            gameData: gameData,
            sgin: sign,
            dynamicData: JSON.stringify(dynamicData)
        };
        if (rankId) {
            param.rankId = rankId;
        }
        const net: INetData = {
            name: 'ngameSubmit',
            uri: '/hdtool/recon/ngame/ngameSubmit',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 游戏多次领奖
     * @param callback 回调
     * @param orderId 订单号
     * @param score 分数
     * @param gameData 游戏数据
     * @param dynamicData 动态数据
     * @param submitToken 提交数据token  由 getNgameStartStatus 返回
     * @param rankId 排行id
     */
    public static ngameManySubmit(callback: Function, orderId: number, score: number, gameData: any, dynamicData: any, submitToken: string, rankId?: number): void {
        const sign = NetManager.ins['createSgin'](orderId, score, gameData, submitToken);
        const param: any = {
            orderId: orderId,
            score: score,
            gameData: gameData,
            sgin: sign,
            dynamicData: JSON.stringify(dynamicData)
        };
        if (rankId) {
            param.rankId = rankId;
        }
        const net: INetData = {
            name: 'ngameManySubmit',
            uri: '/hdtool/recon/ngame/ngameManySubmit',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 游戏数据校验防作弊
     * @param callback 回调
     * @param orderId 订单id
     * @param dynamicData 动态数据
     * @param duibaId duiba活动id
     */
    public static datapash(callback: Function, orderId: number, dynamicData: any): void {
        const param: any = {
            orderId: orderId,
            dynamicData: dynamicData,
            duibaId: window['CFG'].hdToolId
        };
        const net: INetData = {
            name: 'datapash',
            uri: '/hdtool/recon/ngame/datapash',
            type: 'post',
            dataType: 'json',
            param: param,
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 复活接口
     * @param callback 回调
     * @param orderId 订单id
     */
    public static resurrection(callback: Function, orderId: number): void {
        const param: any = {
            orderId: orderId
        };
        const net: INetData = {
            name: 'resurrection',
            uri: '/hdtool/recon/ngame/resurrection',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 轮询复活状态
     * @param callback 回调
     * @param orderId 订单id
     * @param pollingCheck 轮询条件
     * @param pollingCount 轮询次数
     * @param resurrecOrderId 复活订单id
     */
    public static resurrectionStatus(callback: Function, orderId: number, pollingCheck?: Function, pollingCount = 10, resurrecOrderId = -1): void {
        const param: any = {
            orderId: orderId
        };
        const net: INetData = {
            name: 'resurrectionStatus',
            uri: '/hdtool/recon/ngame/resurrectionStatus',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        if (resurrecOrderId != -1) {
            net.param.resurrecOrderId = resurrecOrderId;
        }
        NetManager.ins.send(net);
    }

    /**
     * 轮询订单状态
     * @param callback 回调
     * @param orderId 订单id
     */
    public static getOrderStatus(callback: Function, orderId: any, pollingCheck?: Function, pollingCount = 10): void {
        const param: any = {
            orderId: orderId
        };
        const net: INetData = {
            name: 'getOrderStatus',
            uri: '/hdtool/recon/getOrderStatus',
            type: 'post',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        NetManager.ins.send(net);
    }

    /**
     * 招商银行钓龙虾定制接口
     * @param callback 回调
     * @param activityId 活动id cfg oaid
     * @param score 分数
     * @param shareCode 分享码
     */
    public static shrimpFishingIndex(callback: Function, activityId: number, score?: number, shareCode?: string): void {
        const param: any = {
            activityId: activityId
        };
        if (score) {
            param.score = score;
        }
        if (shareCode) {
            param.shareCode = shareCode;
        }
        const net: INetData = {
            name: 'shrimpFishingIndex',
            uri: '/aaw/changshaCmb/shrimpFishing/index',
            type: 'get',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager.ins.send(net);
    }


    /**
     * 活动中奖名单轮播信息
     * @param callback 回调
     * @param id 活动id 支持多id以逗号符分割
     * @param type 查询类型 0：入库活动（自定义活动工具、新活动工具） 1：插件活动 2、集卡
     * @param count 期望获取数量 默认100
     */
    public static winners(callback: Function, id: number, type: number, count: number = 100): void {
        const param: any = {
            id: id,
            type: type,
            count: count
        };
        const net: INetData = {
            name: 'winners',
            uri: '/activity_winner/winners',
            type: 'get',
            dataType: 'json',
            param: param,
            hideMsg: true,
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 开发者任务列表查询
     * @param callback 回调
     * 返回的主要参数说明：
     * status 任务状态： 任务完成状态，去完成（false），待领奖（process），已领奖（success）
     * credits 用户完成任务可获得的积分
     */
    public static queryTaskList(callback: Function, ) {
        const param: any = {
        };
        const net: INetData = {
            name: 'queryTaskList',
            uri: '/customActivity/task/queryTaskList',
            type: 'get',
            dataType: 'json',
            param: param,
            callback: callback
        };
        NetManager.ins.send(net);
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // 养成签到
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * 查询签到信息
     * @param callback 回调
     * @param signActivityId 签到活动Id
     */
    public static getSignInfo(callback: Function, signActivityId: number) {
        const net: INetData = {
            name: 'getSignInfo',
            uri: '/signactivity/getSignInfo',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: {
                signActivityId: signActivityId
            },
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 签到
     * @param callback 回调
     * @param id 签到活动ID
     * @param activityId 插件ID，如果前端输入该值，则按照前端的输入的插件来加抽奖次数，否则按后台配置的插件加抽奖次数
     * @param signActType 签到活动类型，2：日历签到，7：拉新签到，默认值2，拉新签到必填
     */
    public static doSign(callback: Function, id: number, activityId?, signActType = 2) {
        let param: any = {
            id: id
        }
        if (activityId) {
            param.activityId = activityId;
        }
        if (signActType) {
            param.signActType = signActType;
        }
        const net: INetData = {
            name: 'doSign',
            uri: '/signactivity/doSign',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };

        NetManager.ins.send(net);
    }

    /**
     * 签到结果查询
     * @param callback 回调
     * @param logId 签到流水id
     * @param pollingCheck 轮询判断函数
     * @param pollingCount 轮询次数
     */
    public static getSignResult(callback: Function, logId: number, pollingCheck: Function, pollingCount = 10) {
        const net: INetData = {
            name: 'getSignResult',
            uri: '/signactivity/getSignResult',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: {
                logId: logId
            },
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        NetManager.ins.send(net);
    }

    /**
         * 获取多宠物列表
         * @param callback 
         * @param activityId 
         */
    public static getPetsInfo(callback: Function, activityId: number): void {
        const net: INetData = {
            name: 'getPetsInfo',
            uri: '/signpet/getPetsInfo',
            type: 'get',
            dataType: 'json',
            hideMsg: true,
            param: {
                activityId: activityId
            },
            callback: callback
        };
        NetManager.ins.send(net);
    }
    /**
     * 宠物配置列表
     * @param callback 回调
     * @param activityId 活动id
     */
    public static getPetsConfig(callback: Function, activityId: number): void {
        const net: INetData = {
            name: 'getPetsConfig',
            uri: '/signpet/configs',
            type: 'get',
            dataType: 'json',
            hideMsg: true,
            param: {
                activityId: activityId
            },
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 宠物领养
     * @param {number} activityId 宠物养成活动ID
     */
    public static petAdopte(callback: Function, activityId: number, petName: string, petIdentifier: string, petConfigId: number): void {
        const net: INetData = {
            name: "adopte",
            uri: '/customActivity/haidilao/signpet/adopte',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: {
                activityId: activityId,
                petName: petName,
                petIdentifier: petIdentifier,
                petConfigId: petConfigId
            },
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 查询加减积分结果
     * @param callback 回调
     * @param type 1减积分，2加积分
     * @param orderNum 订单号
     */
    public static answer(callback: Function, type: number, orderNum: any, pollingCheck: Function, pollingCount: number = 10) {
        const net: INetData = {
            name: 'answer',
            uri: '/plugin/credits/answer',
            type: 'get',
            dataType: 'json',
            hideMsg: true,
            param: {
                type: type,
                orderNum: orderNum
            },
            callback: callback,
            pollingCheck: pollingCheck,
            pollingCount: pollingCount
        };
        NetManager.ins.send(net);
    }

    /*/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // 集卡
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////*/
    /**
     * 用户集卡信息及奖项
     * @param callback 
     * @param collectRuleId 
     */
    public static getCollectRule(callback: Function, collectRuleId: number): void {
        const net: INetData = {
            name: 'getCollectRule',
            uri: '/plugin/collectRule/getCollectRule',
            type: 'get',
            dataType: 'json',
            hideMsg: true,
            param: {
                collectRuleId: collectRuleId
            },
            callback: callback
        };
        NetManager.ins.send(net);
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // 定制接口
    /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /**
     * 海底捞收获锅底
     * @param callback 回调
     * @param petId 宠物id
     * @param activityId 活动id
     */
    public static collectSoup(callback: Function, petId: number, activityId: number): void {
        const param: any = {
            petId: petId,
            activityId: activityId
        };
        const net: INetData = {
            name: 'collectSoup',
            uri: '/customActivity/haidilao/signpet/takePrize',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };
        NetManager.ins.send(net);
    }


    /**
         * 海底捞火锅加热
         * @param callback 回调
         * @param petId 宠物id
         * @param activityId 活动id
         */
    public static heatSoup(callback: Function, petId: number, activityId: number): void {
        const param: any = {
            petId: petId,
            activityId: activityId
        };
        const net: INetData = {
            name: 'heatSoup',
            uri: '/customActivity/haidilao/signpet/feed',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 海底捞火锅养成任务列表
     * @param callback 回调
     * @param activityId 活动id
     */
    public static taskList(callback: Function, activityId: any) {
        const param: any = {
            activityId: activityId
        }
        const net: INetData = {
            name: 'taskList',
            uri: '/customActivity/haidilao/signpet/task/list',
            type: 'get',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };
        NetManager.ins.send(net);
    }

    /**
     * 海底捞火锅养成任务领奖
     * @param callback 回调
     * @param petId 任务id
     * @param activityId 活动id
     */
    public static takePrize(callback: Function, taskId: number, activityId: number): void {
        const param: any = {
            taskId: taskId,
            activityId: activityId
        };
        const net: INetData = {
            name: 'takePrize',
            uri: '/customActivity/haidilao/signpet/task/takePrize',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };
        NetManager.ins.send(net);
    }


    public static openCollectGoodsPrize(callback: Function, collectRuleId: any, grade: number) {
        const param: any = {
            collectRuleId: collectRuleId,
            grade: grade
        }
        const net: INetData = {
            name: 'openCollectGoodsPrize',
            uri: '/plugin/collectRule/openCollectGoodsPrize',
            type: 'post',
            dataType: 'json',
            hideMsg: true,
            param: param,
            callback: callback
        };
        NetManager.ins.send(net);
    }
}