import { PetsInfoData } from './../libs/tw/data/pets/PetsInfoData';

import { Buried } from './../libs/tw/util/Buried';
import { GDispatcher } from './../libs/tc/util/GDispatcher';
import { DataManager } from './../libs/tw/manager/DataManager';
import { ABNetManager } from './../libs/tc/manager/ABNetManager';
import { INetData } from './../libs/tc/interface/INetData';
import MainBase from "../libs/tl/MainBase";
import { NetManager } from "../libs/tw/manager/NetManager";
import PanelCtrl from "./ctrls/panelCtrl";
import SceneCtrl from "./ctrls/sceneCtrl";
import { ModuleTypes } from "./types/sceneTypes";
import RulePanel from './rulePanel/RulePanel';
import Msg from "./alert/Msg";
import GameConst, { wait } from './GameConst';
import Waiting from './waiting/Waiting';
import NetConst from './NetConst';
import NoPrizePanel from './prize/NoPrizePanel';
import PrizePanel from './prize/PrizePanel';
import ToastCtrl from './ctrls/toastCtrl';
// import SVGACtrl from './ctrls/svgaCtrl';
import LoginPanel from './login/LoginPanel';
import GetCreditsPanel from './getCredits/GetCreditsPanel';
import SVGACtrl from './ctrls/svgaCtrl';
import MainScene from './mainScene/MainScene';
import AdoptSoupPanel from './adoptSoup/AdoptSoupPanel';
import WarningPanel from './warning/WarningPanel';
import ConsumePanel from './consume/ConsumePanel';
import NetModel from './NetModel';
import FirstSignPrizePanel from './sign/FirstSignPrizePanel';
import SignPrizePanel from './sign/SignPrizePanel';
import FullSignPrizePanel from './sign/FullSignPrizePanel';
import ExchangeTipPanel from './exchangeTip/ExchangeTipPanel';
import CollectPotSucPanel from './prize/CollectPotSucPanel';
import MovieClipCtrl from './ctrls/MovieClipCtrl';

class Main extends MainBase {

    protected registerModules() {

        // 注册Toast
        ToastCtrl.instance.registerClass();
        // 注册所有Panel
        PanelCtrl.instance.registerClass(ModuleTypes.LOGIN_PANEL, LoginPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.GETCREDITS_PANEL, GetCreditsPanel)
        PanelCtrl.instance.registerClass(ModuleTypes.MSG_PANEL, Msg);
        PanelCtrl.instance.registerClass(ModuleTypes.RULE_PANEL, RulePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.FIRST_SIGN_PRIZE_PANEL, FirstSignPrizePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.SIGN_PRIZE_PANEL, SignPrizePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.FULL_SIGN_PRIZE_PANEL, FullSignPrizePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.PRIZE_PANEL, PrizePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.NOPRIZE_PANEL, NoPrizePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.CONSUME_PANEL, ConsumePanel);
        PanelCtrl.instance.registerClass(ModuleTypes.ADOPTSOUP_PANEL, AdoptSoupPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.WARNING_PANEL, WarningPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.EXCHANGETIP_PANEL, ExchangeTipPanel);
        PanelCtrl.instance.registerClass(ModuleTypes.COLLECTPOTSUC_PANEL, CollectPotSucPanel);
        // 注册所有Scene
        SceneCtrl.instance.registerClass(ModuleTypes.MAIN_SCENE, MainScene);
        // NetManager.ins.onNotSuccess = (msg) => {
        //     showAlertPanel(msg)
        // }
    }

    // 获取数据
    public updateCount: number = 0;
    protected async getData() {
        super.getData();
        //加载svga
        // let mv = await SVGACtrl.instance.load("http://yun.duiba.com.cn/db_games/activity/garbageSorting1.00/guideTips.svga");
        // let soundArr = ["numCountDown_mp3", "rightTips_mp3"]
        // preloadSound(soundArr);

    }



    // 设置派发事件
    protected GDispatchEvent() {
        GDispatcher.addEvent(ABNetManager.ERROR, (net: INetData, msg = '') => {
            const msgData = {
                net: net,
                msg: msg,
                // sureBtnTxt: TlLang.lang_011
            };
            PanelCtrl.instance.show(ModuleTypes.MSG_PANEL, msgData)
        }, this);
        // 监听当预加载资源加载完毕
        GDispatcher.addEvent('PreloadLoaded', () => {
            Waiting.instance.show()
            // await MovieClipCtrl.instance.init();
            // this.createGameScene()
        }, this);
        GDispatcher.addEvent('DelayLoaded', () => {
            Waiting.instance.hide()
            this.createGameScene()
        }, this);
    }

    protected onResourceLoadComplete(event: RES.ResourceEvent): void {
        if (event.groupName == "Preload") {
            this.trace("preload组加载完成");
            this.trace("开始加载Normal资源");
            // this.loadBg("startBg.png");
            GDispatcher.dispatchEvent('PreloadLoaded');
            window['isPreloadLoaded'] = true;
            RES.loadGroup("Guide");
        } else if (event.groupName == "Guide") {
            this.trace("Guide组加载完成");
            this.trace("开始加载Light资源");
            GDispatcher.dispatchEvent('GuideLoaded');
            RES.loadGroup("Light");
        } else if (event.groupName == "Light") {
            this.trace("Light组加载完成");
            this.trace("开始加载Normal资源");
            GDispatcher.dispatchEvent('LightLoaded');
            RES.loadGroup("Normal");
        } else if (event.groupName == "Normal") {
            this.trace("Normal组加载完成");
            this.trace("开始加载Delay资源");
            GDispatcher.dispatchEvent('NormalLoaded');
            RES.loadGroup("Delay");
        } else if (event.groupName == "Delay") {
            this.trace("Delay组加载完成");
            GDispatcher.dispatchEvent('DelayLoaded');
            RES.removeEventListener(RES.ResourceEvent.GROUP_COMPLETE, this.onResourceLoadComplete, this);
            RES.removeEventListener(RES.ResourceEvent.GROUP_LOAD_ERROR, this.onResourceLoadError, this);
            RES.removeEventListener(RES.ResourceEvent.GROUP_PROGRESS, this.onResourceProgress, this);
        }
    }

    // 创建游戏场景
    protected async createGameScene() {
        super.createGameScene();
        //获取UA信息
        let userAgent = navigator.userAgent.toLowerCase();
        console.log(userAgent);
        GameConst.stage = this.stage;
        setTimeout(() => {
            console.log(GameConst.stage.width, GameConst.stage.height)
        }, 100);

        Buried.init();
        // 端内发接口
        await Promise.all([NetModel.getPetsInfo(), NetModel.getSignInfo(), NetModel.winners(2), NetModel.getPetsConfig()]);
        // console.log(DataManager.ins.getPetsInfoData, DataManager.ins.getData("getSignInfo"), DataManager.ins.getData("winners"));
        // console.log("change");

        SceneCtrl.instance.change(ModuleTypes.MAIN_SCENE)

    }

    /**
     * 资源组加载出错
     */
    protected onResourceLoadError(event: RES.ResourceEvent): void {
        this.trace("preload组加载失败");
        //忽略加载失败的项目
        this.onResourceLoadComplete(event);
    }

}

window['Main'] = Main;
egret.ImageLoader.crossOrigin = "anonymous";
egret.runEgret({
    renderMode: "webgl", audioType: 0, calculateCanvasScaleFactor: function (context: any) {
        var backingStore = context.backingStorePixelRatio ||
            context.webkitBackingStorePixelRatio ||
            context.mozBackingStorePixelRatio ||
            context.msBackingStorePixelRatio ||
            context.oBackingStorePixelRatio ||
            context.backingStorePixelRatio || 1;
        return (window.devicePixelRatio || 1) / backingStore;
    }
});