export class MyProgressBar extends eui.Component{
    public barImg:eui.Image;
    public scoreLb:eui.Label;
    public barIcon:eui.Image;
    private shape:egret.Shape;

    private tSpeed:number;

    private callBack:Function;

    /**
     * 
     * @param lv 等级
     * @param name 狗名
     * @param iconName 资源名
     * @param callBack 
     */
    constructor(tSpeed:number,callBack:Function = null){
        super();
        this.skinName       = 'resource/skins/ui/MyProgressBarSkin.exml';
        this.tSpeed         = tSpeed;

        this.addEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        if (this.skin) {
            this.onSkinComplete();
        }
        
        this.callBack = callBack;
    }

    private onSkinComplete():void{

        this.removeEventListener(egret.Event.COMPLETE, this.onSkinComplete, this);
        this.shape = new egret.Shape();
        this.shape.graphics.beginFill(0);
        this.shape.graphics.drawRoundRect(7, 5, 500, 28, 33, 33);
        this.shape.graphics.endFill();

        this.addChild(this.shape);
        this.barImg.mask = this.shape;

        this.imgSource = 0;



        // this.barVal = 100;
        // let i = 0;
        // setInterval(()=>{
        //     if(i < 100){
        //         i += 10;
        //         this.barVal = i;
        //     }
        // }, 300)

    }

    public set imgSource(idx:number){
        this.barImg.source = 'bar' + idx + '_png';
    }

    public set barVal(val:number){
        egret.Tween.get(this.barImg).to({x:-470 * (1 - val / 100)} ,this.tSpeed);
        egret.Tween.get(this.barIcon).to({x:470 * val / 100} ,this.tSpeed);
        // this.barImg.x = -470 * (1 - val / 100);
        // this.barIcon.x = 470 * val / 100;
    }

    public removeEvent():void{
    }

}