import { DataManager } from './../../libs/tw/manager/DataManager';
import { ModuleTypes } from './../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import { VideoEntity } from '../../libs/SVGA';
import SceneCtrl from '../ctrls/sceneCtrl';
import { NetName } from '../../libs/tw/enum/NetName';
import { stopAllSound, playSound } from '../ctrls/soundCtrl';
export default class StartScene1 extends Scene {
    public ruleBtn:eui.Button;
    public soundBtn:eui.Button;
    public prizeBtn:eui.Button;
    public headImg:eui.Image;

    public mainGroup:eui.Group;
    public actGroup:eui.Group;
    public changeRect:eui.Rect;

    private qt01:SVGA.EgretMovieClip;
    private qt02:SVGA.EgretMovieClip;
    private qt03:SVGA.EgretMovieClip;
    public startBtn0:SVGA.EgretMovieClip;
    public startBtn1:SVGA.EgretMovieClip;
    public roleHead:SVGA.EgretMovieClip;
    private parser:SVGA.Parser;

    // 用于控制全局音乐是否播放和音乐按钮状态
    public static isPlayMusic: boolean = true;

    public get skinKey() { return 'StartScene' }
    public get groupName() { return 'start_scene' }

    constructor(data?) {
        super(data);

    }
    showAct():void{
        // this.alpha = 0;
        // egret.Tween.get(this).to({alpha:1}, 800);
    }

    initEvents() {
        super.initEvents();
        this.ruleBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.soundBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_soundBtn, this);
        this.prizeBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);

        // this.addEventListener(egret.TouchEvent.TOUCH_END, this.onTap_this, this);
        // this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_this, this);
    }

    removeEvents() {
        super.removeEvents();

        this.soundBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_soundBtn, this);
        this.ruleBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ruleBtn, this);
        this.prizeBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_prizeBtn, this);

        this.removeEventListener(egret.TouchEvent.TOUCH_END, this.onTap_this, this);
        this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_this, this);
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('startBg_jpg');
        await RES.loadGroup('common');
        this.qt01 = await PanelCtrl.instance.getSvga('resource/assets/svga/start/qt01.svga') as SVGA.EgretMovieClip;
        this.qt02 = await PanelCtrl.instance.getSvga('resource/assets/svga/start/qt02.svga') as SVGA.EgretMovieClip;
        this.qt03 = await PanelCtrl.instance.getSvga('resource/assets/svga/start/qt03.svga') as SVGA.EgretMovieClip;
        this.startBtn0 = await PanelCtrl.instance.getSvga('resource/assets/svga/start/startBtn0.svga') as SVGA.EgretMovieClip;
        this.startBtn1 = await PanelCtrl.instance.getSvga('resource/assets/svga/start/startBtn1.svga') as SVGA.EgretMovieClip;
        this.roleHead = await PanelCtrl.instance.getSvga('resource/assets/svga/start/roleHead.svga') as SVGA.EgretMovieClip;

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
        
        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private bLocalX:number = 0;
    private onTap_this(e:egret.TouchEvent):void{
        console.log('e.localX',e.localX);
        console.log('value', e.localX - this.bLocalX);
        let val = e.localX - this.bLocalX;
        if(Math.abs(val) > window['space']){
            if(val < 0){//向左
                // SceneCtrl.instance.change(ModuleTypes.SCENE2);
                this.removeEventListener(egret.TouchEvent.TOUCH_END, this.onTap_this, this);
                this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_this, this);

            }else{//向右
            }
        }
    }

    private onBegin_this(e:egret.TouchEvent):void{
        console.log('e.localX',e.localX);
        this.bLocalX = e.localX;

    }

    private onLoad(): void {
        let startDpmOut; 
        let startDcmOut;
        let exposure;

        if(window['isapp']){//端内
            startDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
            startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
            NetManager.ins.showLog(exposure);
    
            startDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
            startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            exposure = Buried.createExposure(startDpmOut, startDcmOut);

            NetManager.ins.showLog(exposure);
            //音乐曝光
            startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
            startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            exposure = Buried.createExposure(startDpmOut, startDcmOut);

            NetManager.ins.showLog(exposure);

            //开始按钮曝光
            startDpmOut = Buried.connectDpm(110, 4, 1); // 点击埋点   
            startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            exposure = Buried.createExposure(startDpmOut, startDcmOut);

            NetManager.ins.showLog(exposure);
        }else{

            startDpmOut = Buried.connectDpm(110, 13, 1); // 点击埋点   
            startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            exposure = Buried.createExposure(startDpmOut, startDcmOut);

            NetManager.ins.showLog(exposure);

        }

        this.initUI();
    }

    private initUI(): void {
        if(!window['isapp']){//端外
            this.ruleBtn.visible = false;
            this.prizeBtn.visible = false;
        }else{
            this.ruleBtn.visible = true;
            this.prizeBtn.visible = true;
        }

        this.initData();
        this.initSvga();

    }

    private initData(isPlay:boolean = false):void{
        this.actGroup.visible = true;
    }

    private initSvga():void{
        this.changeRect.alpha = 0;

        this.mainGroup.addChild(this.roleHead);
        this.roleHead.stop();

        //初始化常态蜻蜓
        this.qt01.x = 328;
        this.qt01.y = 1070;
        this.qt01.play();
        this.mainGroup.addChild(this.qt01);

        setTimeout(() => {
            this.startBtn0.play();
            this.startBtn1.play();
        }, 330);
        this.startBtn0.touchEnabled = true;
        this.startBtn0.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_start, this);
        this.mainGroup.addChild(this.startBtn0);
        this.startBtn0.stop();

        this.startBtn1.touchEnabled = true;
        this.startBtn1.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_start, this);
        this.mainGroup.addChild(this.startBtn1);
        this.startBtn1.stop();

        let data = DataManager.ins.getData(NetName.GET_INFO).data;
        if(data.actPayload == 1){
            this.startBtn1.visible = true;
            this.startBtn0.visible = false;

        }else if(data.actPayload == 2){
            this.startBtn1.visible = false;
            this.startBtn0.visible = true;
        }else{
            this.startBtn1.visible = false;
            this.startBtn0.visible = true;
        }

    }

    private onTap_start():void{
        if(window['isapp']){
            let startDpmOut = Buried.connectDpm(110, 4, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
            NetManager.ins.clickLog(exposure);

        }else{

            let startDpmOut = Buried.connectDpm(110, 13, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);

            NetManager.ins.clickLog(exposure);

        }

        //处理音频自动播放，每个audio标签都要获取一次交互操作，接下来才能自动播放
        var music:any = document.getElementById('music');
        music.src = 'https://yun.duiba.com.cn/db_games/activity/music/w20191006/sound2.mp3';
        // music.onLoad();
        if(music){
            music.play();
            music.pause();
        }

        this.startBtn0.touchEnabled = false;
        this.startBtn1.touchEnabled = false;

        this.startBtn0.stop();
        this.startBtn1.stop();

        this.touchEnabled = false;
        this.touchChildren = false;
        
        this.qt01.stop();
        this.mainGroup.removeChild(this.qt01);
        //起手式蜻蜓
        this.qt02.x = 328;
        this.qt02.y = 1070;
        this.qt02.startAniRange(1, this.qt02.totalFrames, 1, ()=>{
            this.actGroup.addChildAt(this.qt03, 0);
            this.qt03.startAniRange(1, this.qt03.totalFrames, 1);
        });
        this.mainGroup.addChild(this.qt02);

        setTimeout(() => {
            this.roleHead.startAniRange(1, this.roleHead.totalFrames, 1);
            this.headImg.visible = false;
        }, 500);
        setTimeout(() => {
            this.mainGroup.verticalCenter = NaN;
            egret.Tween.get(this.mainGroup).to({y:3429-1624}, 1500, egret.Ease.cubicIn).call(()=>{
                egret.Tween.get(this.changeRect).to({alpha:1}, 300).call(()=>{
                    //切换到下一个场景
                    SceneCtrl.instance.change(ModuleTypes.SCENE2);
                });
            });
        }, 2500);
        //3429

    }


    private onTap_ruleBtn(): void {

        console.log('点击rule');
        PanelCtrl.instance.btnDelay(this.ruleBtn);
        PanelCtrl.instance.show(ModuleTypes.RULE_PANEL);

        let startDpmOut = Buried.connectDpm(110, 1, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);
    }


    private onTap_prizeBtn(): void {
        console.log('点击prizeBtn');
        PanelCtrl.instance.btnDelay(this.prizeBtn);//devhttp://activity.m.duibadev.com.cn/projectx/p274df766/fe1df32fa.html
        window.location.href = window['prizeUel'] ? window['prizeUel'] : 'http://activity.m.duiba.com.cn/projectx/pec94f48f/fd81c1ad9.html';


        let startDpmOut = Buried.connectDpm(110, 2, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);
    }

    private onTap_soundBtn(){
        PanelCtrl.instance.btnDelay(this.soundBtn);
        let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);

        if(StartScene1.isPlayMusic){
            StartScene1.isPlayMusic = false;
            this.soundBtn.currentState = 'disabled';
            window['musicPlay'](false);
            stopAllSound();
        }else{
            StartScene1.isPlayMusic = true;
            this.soundBtn.currentState = 'up';
            window['musicPlay'](true);
        }
        // toggleSound()
    }

}
