import { DataManager } from '../../libs/tw/manager/DataManager';
import { ModuleTypes } from '../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import { VideoEntity } from '../../libs/SVGA';
import SceneCtrl from '../ctrls/sceneCtrl';
import { playSound, stopAllSound } from '../ctrls/soundCtrl';
import StartScene1 from '../startScene/StartScene';
export default class Scene5 extends Scene {
    private tidx:number;
    public textBg:eui.Image;
    public mainGroup:eui.Group;
    public soundBtn:eui.Button;
    private arrow:SVGA.EgretMovieClip;

    private wuqi0:SVGA.EgretMovieClip;
    private wuqi1:SVGA.EgretMovieClip;
    private wuqi2:SVGA.EgretMovieClip;

    private tTxtTimes:any[];

    public get skinKey() { return 'Scene5' }
    public get groupName() { return 'scene5' }

    constructor(data?) {
        super(data);

    }

    initEvents() {
        super.initEvents();

        this.addEventListener(egret.TouchEvent.TOUCH_END, this.onTap_this, this);
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_this, this);
        this.soundBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_soundBtn, this);
    }

    removeEvents() {
        super.removeEvents();

        this.removeEventListener(egret.TouchEvent.TOUCH_END, this.onTap_this, this);
        this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_this, this);
        this.soundBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_soundBtn, this);
    }

    private bLocalX:number = 0;
    private onTap_this(e:egret.TouchEvent):void{
        console.log('e.localX',e.localX);
        console.log('value', e.localX - this.bLocalX);
        let val = e.localX - this.bLocalX;
        if(Math.abs(val) > window['space']){
            clearTimeout(this.settimeIdx);
            clearTimeout(this.tidx);
            // stopAllSound();
            if(val < 0){//向左
                SceneCtrl.instance.change(ModuleTypes.SCENE6);
                this.removeEventListener(egret.TouchEvent.TOUCH_END, this.onTap_this, this);
                this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_this, this);
                var music:any = document.getElementById('music');
                if(music){
                    music.pause();
                }

            }else{//向右
                // SceneCtrl.instance.change(ModuleTypes.SCENE4);
            }
        }
    }

    private onBegin_this(e:egret.TouchEvent):void{
        console.log('e.localX',e.localX);
        this.bLocalX = e.localX;

        if(window['isapp']){//端内
            let startDpmOut = Buried.connectDpm(110, 8, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
            NetManager.ins.clickLog(exposure);
        }else{
            let startDpmOut = Buried.connectDpm(110, 17, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
            NetManager.ins.clickLog(exposure);

        }
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('startBg_jpg');
        this.wuqi0 = await PanelCtrl.instance.getSvga('resource/assets/svga/scene5/s5wuqi0.svga') as SVGA.EgretMovieClip;
        this.wuqi1 = await PanelCtrl.instance.getSvga('resource/assets/svga/scene5/s5wuqi1.svga') as SVGA.EgretMovieClip;
        this.wuqi2 = await PanelCtrl.instance.getSvga('resource/assets/svga/scene5/s5wuqi2.svga') as SVGA.EgretMovieClip;
        this.arrow = await PanelCtrl.instance.getSvga('resource/assets/svga/start/arrow.svga') as SVGA.EgretMovieClip;

        for(let i = 0; i < 7; i++){
            this['s5mv' + i] = await PanelCtrl.instance.getSvga('resource/assets/svga/scene5/s5mv' + i + '.svga') as SVGA.EgretMovieClip;
        }
        // await RES.getResAsync('sound5_mp3');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
        
        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad(): void {

        if(window['isapp']){//端内
            let startDpmOut = Buried.connectDpm(110, 8, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
            NetManager.ins.showLog(exposure);
        }else{
            let startDpmOut = Buried.connectDpm(110, 17, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
            NetManager.ins.showLog(exposure);

        }

        this.initSoundBtn();

        this.initData();
        this.initUI();
        if(StartScene1.isPlayMusic){
            this.tidx = setTimeout(() => {
                // playSound('sound5');
    
                var music:any = document.getElementById('music');
                music.src = 'https://yun.duiba.com.cn/db_games/activity/music/w20191006/sound5.mp3';
                if(music){
                    music.play();
                }
            }, 2 * 1000);
        }
    }

    private initData():void{
        this.tTxtTimes = [
            {s:3, e:6, h:282},
            {s:6.67, e:9.67, h:322}
        ]
    }

    private initUI(): void {
        this.initAct();
        this.initSvga();
        
        this.mainGroup.addChild(this.textBg);
        this.mainGroup.addChild(this['text0']);
        this.mainGroup.addChild(this['text1']);

    }

    private settimeIdx:any;
    private initAct():void{
        this.textBg.alpha = 0;
        //文字背景动效
        egret.Tween.get(this.textBg).wait(2000).to({alpha:1}, 500);

        for(let i = 0; i < 2; i++){
            this.setTxtAct(this.tTxtTimes[i].s, this.tTxtTimes[i].e, this.tTxtTimes[i].h, this['text' + i]);
        }
        
        let len = this.tTxtTimes.length;
        this.settimeIdx = setTimeout(() => {
            console.log('切换场景6');
            SceneCtrl.instance.change(ModuleTypes.SCENE6);
            this.removeEvents();
        }, this.tTxtTimes[len - 1].e * 1000 + 1000);

        window['toutArr'].push(this.settimeIdx);
    }

    private setTxtAct(stime:number, etime:number, h:number, target:eui.Component):void{
        let shap = new egret.Shape();
        shap.graphics.beginFill(0);
        shap.graphics.drawRect(0, 0, 37, h);
        shap.x = target.x;
        shap.y = target.y - h;
        this.mainGroup.addChild(shap);

        target.mask  = shap;

        setTimeout(() => {
            egret.Tween.get(shap).to({y:target.y}, (etime - stime) * 1000);
        }, stime * 1000);
    }

    private initSvga():void{

        for(let i = 0; i < 7; i++){
            this.mainGroup.addChild(this['s5mv' + i]);
            if(i == 4 || i == 5){
                this['s5mv' + i].stop();
            }
        }

        setTimeout(() => {
            this['s5mv4'].play();
        }, 5500);

        setTimeout(() => {
            this['s5mv5'].play();
        }, 2000);

        this.wuqiact();

        this.mainGroup.addChild(this.soundBtn);

        setTimeout(() => {
            this.mainGroup.addChild(this.arrow);
            this.arrow.x = 50;
            this.arrow.y = 100;
            setTimeout(() => {
                this.arrow.stop();
                this.arrow.visible = false;
            }, window['disTime'] ? window['disTime'] : 1000);
        }, 1000);
    }

    private isstop:boolean;
    private wuqiact():void{
        this.wuqi0.startAniRange(1, this.wuqi0.totalFrames, 1);
        this.mainGroup.addChild(this.wuqi0);

        setTimeout(() => {
            this.wuqi1.startAniRange(1, this.wuqi1.totalFrames, 1);
            this.mainGroup.addChild(this.wuqi1);
        }, 500);

        setTimeout(() => {
            // this.wuqi2.play();
            this.wuqi2.startAniRange(1, this.wuqi2.totalFrames, 1, ()=>{
                if(!this.isstop){
                    this.wuqiact();
                }
            });
            this.mainGroup.addChild(this.wuqi2);
        }, 1000);
    }
    
    private initSoundBtn(){
        if(!StartScene1.isPlayMusic){
            this.soundBtn.currentState = 'disabled';
            window['musicPlay'](false);
            // stopAllSound();
        }else{
            this.soundBtn.currentState = 'up';
            window['musicPlay'](true);
        }
        // toggleSound()
    }
    
    private onTap_soundBtn(){

        let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);
        PanelCtrl.instance.btnDelay(this.soundBtn);
        if(StartScene1.isPlayMusic){
            StartScene1.isPlayMusic = false;
            this.soundBtn.currentState = 'disabled';
            window['musicPlay'](false);
            // stopAllSound();

            var music:any = document.getElementById('music');
            if(music){
                music.pause();
            }
        }else{
            StartScene1.isPlayMusic = true;
            this.soundBtn.currentState = 'up';
            window['musicPlay'](true);
        }
    }

}
