import { DataManager } from '../../libs/tw/manager/DataManager';
import { ModuleTypes } from '../types/sceneTypes';

import Scene from "../views/Scene";
import PanelCtrl from "../ctrls/panelCtrl";
import { NetManager } from '../../libs/tw/manager/NetManager';
import Loading from '../loading/Loading';
import { Buried } from '../../libs/tw/util/Buried';
import { VideoEntity } from '../../libs/SVGA';
import SceneCtrl from '../ctrls/sceneCtrl';
import { playSound, stopAllSound } from '../ctrls/soundCtrl';
import StartScene1 from '../startScene/StartScene';
export default class Scene3 extends Scene {
    private tidx:number;
    public textBg:eui.Image;
    public mainGroup:eui.Group;
    public soundBtn:eui.Button;
    private arrow:SVGA.EgretMovieClip;
    private s3svg0:SVGA.EgretMovieClip;
    private s3svg1:SVGA.EgretMovieClip;
    private s3svg2:SVGA.EgretMovieClip;
    private s3svg3:SVGA.EgretMovieClip;
    private s3svg4:SVGA.EgretMovieClip;
    private s3svg5:SVGA.EgretMovieClip;

    private tTxtTimes:any[];

    public get skinKey() { return 'Scene3' }
    public get groupName() { return 'scene3' }

    constructor(data?) {
        super(data);

    }

    initEvents() {
        super.initEvents();

        this.addEventListener(egret.TouchEvent.TOUCH_END, this.onTap_this, this);
        this.addEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_this, this);
        this.soundBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_soundBtn, this);
    }

    removeEvents() {
        super.removeEvents();

        this.removeEventListener(egret.TouchEvent.TOUCH_END, this.onTap_this, this);
        this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_this, this);
        this.soundBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_soundBtn, this);
    }

    private bLocalX:number = 0;
    private onTap_this(e:egret.TouchEvent):void{
        console.log('e.localX',e.localX);
        console.log('value', e.localX - this.bLocalX);
        let val = e.localX - this.bLocalX;
        if(Math.abs(val) > window['space']){
            clearTimeout(this.settimeIdx);
            clearTimeout(this.tidx);
            if(val < 0){//向左
                SceneCtrl.instance.change(ModuleTypes.SCENE4);
                this.removeEventListener(egret.TouchEvent.TOUCH_END, this.onTap_this, this);
                this.removeEventListener(egret.TouchEvent.TOUCH_BEGIN, this.onBegin_this, this);

                var music:any = document.getElementById('music');
                if(music){
                    music.pause();
                }
            }else{//向右
                // SceneCtrl.instance.change(ModuleTypes.SCENE2);
            }
        }
    }

    private onBegin_this(e:egret.TouchEvent):void{
        console.log('e.localX',e.localX);
        this.bLocalX = e.localX;
        if(window['isapp']){//端内
            let startDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
            NetManager.ins.clickLog(exposure);
        }else{
            let startDpmOut = Buried.connectDpm(110, 15, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
            NetManager.ins.clickLog(exposure);

        }
    }

    start(data?) {
        super.start(data);
        this.percentHeight = 100;
    }

    private bgtexture: egret.Texture;
    protected async preLoadRes() {
        //加载背景并设置背景图片
        // this.bgtexture = await RES.getResAsync('startBg_jpg');
        this.s3svg0 = await PanelCtrl.instance.getSvga('resource/assets/svga/scene3/s3svg0.svga') as SVGA.EgretMovieClip;
        this.s3svg1 = await PanelCtrl.instance.getSvga('resource/assets/svga/scene3/s3svg1.svga') as SVGA.EgretMovieClip;
        this.s3svg2 = await PanelCtrl.instance.getSvga('resource/assets/svga/scene3/s3svg2.svga') as SVGA.EgretMovieClip;
        this.s3svg3 = await PanelCtrl.instance.getSvga('resource/assets/svga/scene3/s3svg3.svga') as SVGA.EgretMovieClip;
        this.s3svg4 = await PanelCtrl.instance.getSvga('resource/assets/svga/scene3/s3svg4.svga') as SVGA.EgretMovieClip;
        this.s3svg5 = await PanelCtrl.instance.getSvga('resource/assets/svga/scene3/s3svg5.svga') as SVGA.EgretMovieClip;
        this.arrow = await PanelCtrl.instance.getSvga('resource/assets/svga/start/arrow.svga') as SVGA.EgretMovieClip;
        // await RES.getResAsync('sound3_mp3');

        return new Promise(function (resolve, reject) {
            resolve();
        });
    }

    protected onSkinComplete(): void {
        super.onSkinComplete();
        
        // this.mainbg.texture = this.bgtexture;

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
    }

    private onLoad(): void {


        if(window['isapp']){//端内
            let startDpmOut = Buried.connectDpm(110, 6, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
            NetManager.ins.showLog(exposure);
        }else{
            let startDpmOut = Buried.connectDpm(110, 15, 1); // 点击埋点   
            let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
            let exposure = Buried.createExposure(startDpmOut, startDcmOut);
    
            NetManager.ins.showLog(exposure);

        }

        this.initSoundBtn();
        this.initData();
        this.initUI();

        var music:any = document.getElementById('music');
        music.src = 'https://yun.duiba.com.cn/db_games/activity/music/w20191006/sound3.mp3';
        if(StartScene1.isPlayMusic){
            this.tidx = setTimeout(() => {
                // playSound('sound3');
                if(music){
                    music.play();
                }
            }, 1 * 1000);
        }

    }

    private initData():void{
        this.tTxtTimes = [
            {s:3, e:4.5, h:200},
            {s:5, e:6.5, h:203},
            {s:7, e:8.5, h:203},
            {s:9, e:10.5, h:199}
        ]
    }

    private initUI(): void {
        this.initAct();
        this.initSvga();

    }

    private settimeIdx:any;
    private initAct():void{
        this.textBg.alpha = 0;
        //文字背景动效
        egret.Tween.get(this.textBg).wait(2000).to({alpha:1}, 500);

        for(let i = 0; i < 4; i++){
            this.setTxtAct(this.tTxtTimes[i].s, this.tTxtTimes[i].e, this.tTxtTimes[i].h, this['text' + i]);
        }
        
        let len = this.tTxtTimes.length;
        this.settimeIdx = setTimeout(() => {
            //切换场景3
            console.log('切换场景4');
            SceneCtrl.instance.change(ModuleTypes.SCENE4);
            this.removeEvents();
        }, this.tTxtTimes[len - 1].e * 1000 + 1000);

        window['toutArr'].push(this.settimeIdx);
    }

    private setTxtAct(stime:number, etime:number, h:number, target:eui.Component):void{
        let shap = new egret.Shape();
        shap.graphics.beginFill(0);
        shap.graphics.drawRect(0, 0, 37, h);
        shap.x = target.x;
        shap.y = target.y - h;
        this.mainGroup.addChild(shap);

        target.mask  = shap;

        setTimeout(() => {
            egret.Tween.get(shap).to({y:target.y}, (etime - stime) * 1000);
        }, stime * 1000);
    }

    private initSvga():void{

        for(let i = 0; i < 6; i++){

            this['s3svg' + i].play();
            this.mainGroup.addChild(this['s3svg' + i]);
        }


        this.mainGroup.addChild(this.soundBtn);

        setTimeout(() => {
            this.mainGroup.addChild(this.arrow);
            this.arrow.x = 50;
            this.arrow.y = 100;
            setTimeout(() => {
                this.arrow.stop();
                this.arrow.visible = false;
            }, window['disTime'] ? window['disTime'] : 1000);
        }, 1000);
    }
    
    private initSoundBtn(){
        if(!StartScene1.isPlayMusic){
            this.soundBtn.currentState = 'disabled';
            window['musicPlay'](false);
            // stopAllSound();
        }else{
            this.soundBtn.currentState = 'up';
            window['musicPlay'](true);
        }
    }
    
    private onTap_soundBtn(){
        PanelCtrl.instance.btnDelay(this.soundBtn);

        let startDpmOut = Buried.connectDpm(110, 3, 1); // 点击埋点   
        let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        NetManager.ins.clickLog(exposure);
        if(StartScene1.isPlayMusic){
            StartScene1.isPlayMusic = false;
            this.soundBtn.currentState = 'disabled';
            window['musicPlay'](false);
            // stopAllSound();
            var music:any = document.getElementById('music');
            if(music){
                music.pause();
            }
        }else{
            StartScene1.isPlayMusic = true;
            this.soundBtn.currentState = 'up';
            window['musicPlay'](true);
            
        }
    }

}
