import { LotteryType } from './../../libs/tw/enum/LotteryType';
import Panel from "../views/Panel";
import SceneCtrl from "../ctrls/sceneCtrl";
import { ModuleTypes } from "../types/sceneTypes";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { NetManager } from "../../libs/tw/manager/NetManager";
import PanelCtrl from "../ctrls/panelCtrl";
import Loading from "../loading/Loading";
import { Buried } from '../../libs/tw/util/Buried';
import { NetName } from '../../libs/tw/enum/NetName';
export default class PrizePanel extends Panel {
    private mdata: any;
    private pType: any;

    public prizeImage: eui.Image;
    public closeBtn: eui.Button;
    public prizeNameLb: eui.Label;
    public useBtn: eui.Group;

    public codeGroup:eui.Group;

    public get skinKey() { return 'PrizePanel' }
    public get groupName() { return 'prize_panel' }

    constructor(data: any) {
        super(data);
        this.pType = data;

    }
    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }

        this.showAct(function () {

        }.bind(this));
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.useBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        this.prizeImage.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);

    }

    removeEvents(): void {
        super.removeEvents();
        this.useBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);
        this.prizeImage.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_ok, this);

    }

    private onLoad() {

        // let startDpmOut = Buried.connectDpm(110, 10, 1); // 点击埋点   
        // let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        // let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        // NetManager.ins.showLog(exposure);

        this.codeGroup.visible = false;

        // if(this.pType == 0){
            
        // }else{

        // }
        let data = DataManager.ins.getData(NetName.GET_PRIZE_DETAIL).data;
        if(data.length > 0){
            data = data[0];
            
            this.mdata = data;
    
            this.prizeNameLb.text = this.mdata.name;
            this.prizeImage.source = this.mdata.icon;
        }

    }

    onUse() {
        let data = DataManager.ins.getData(NetName.GET_PRIZE).data;
        window.location.href = data.url;
    }


    private onTap_ok(e: egret.TouchEvent): void {

        // let startDpmOut = Buried.connectDpm(110, 10, 1); // 点击埋点   
        // let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
        // let exposure = Buried.createExposure(startDpmOut, startDcmOut);

        // NetManager.ins.clickLog(exposure);
        
        this.onUse();
        this.onTouchTap();
    }

}