import { HtmlTextParser } from './../ctrls/HtmlTextParser';
import Panel from "../views/Panel";
import { NetManager } from "../../libs/tw/manager/NetManager";
import { DataManager } from "../../libs/tw/manager/DataManager";
import { Buried } from '../../libs/tw/util/Buried';
import PanelCtrl from '../ctrls/panelCtrl';
import { ModuleTypes } from '../types/sceneTypes';
import TopLayerCtrl from '../ctrls/topLayerCtrl';
import { NetName } from '../../libs/tw/enum/NetName';
export default class GameOverPanel extends Panel {
    public closeBtn: eui.Button;
    public knowBtn: eui.Button;
    public shareBtn: eui.Button;

    private type:any;

    public get skinKey() { return 'GameOverPanel' }
    public get groupName() { return 'gameover_panel' }

    constructor(data: any) {
        super(data);
        this.type = data;

    }

    onSkinComplete(): void {
        super.onSkinComplete();

        this.once(egret.Event.ADDED_TO_STAGE, this.onLoad, this);
        if (this.stage) {
            this.onLoad();
        }
        this.showAct();
    }

    start(): void {
        this.percentHeight = 100;
    }

    initEvents(): void {
        super.initEvents();
        this.knowBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this)
        this.shareBtn.addEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this)
    }

    removeEvents(): void {
        super.removeEvents();
        this.knowBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_knowBtn, this)
        this.shareBtn.removeEventListener(egret.TouchEvent.TOUCH_TAP, this.onTap_shareBtn, this)
    }
    onTap_knowBtn() {
        if(this.type == 0){

            if(window['isapp']){
                let startDpmOut = Buried.connectDpm(110, 11, 1); // 点击埋点   
                let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                let exposure = Buried.createExposure(startDpmOut, startDcmOut);
        
                NetManager.ins.clickLog(exposure);
            }
        }
        
        //关闭弹框
        this.hidePanel();
    }

    private onTap_shareBtn():void{
        //关闭弹框
        this.hidePanel();
        this.share();
    }
    private share():void{
        //进入分享流程
        var param = {
			"shareTitle" : window['shareTitle'] ? window['shareTitle'] : '听吴侬软语，寻姑苏美食',// 标题
			"shareTextUrl" : window['shareTextUrl'] ? window['shareTextUrl'] : 'https://activity-1.m.duiba.com.cn/hdtool/index?id=3721052&appKey=U9smCw8qARxWTzoSvL41McNWiRu&openBs=openbs',// 链接
			"shareText" : window['shareText'] ? window['shareText'] : '开启美味追忆之旅，还有大闸蟹、现金红包等小食礼品你来拿哦！',// 分享文本内容
			"sequence":'110',//分享三个按钮的显示与隐藏
			"showDialog":'true', //是否需要底部弹出层
			"shareAlertTitle":'分享', //分享弹出层标题
			"callback":"shareCallBack" //分享回调方法
        };
        
        window['shareCallBack'] = (data)=>{
            let data1 = DataManager.ins.getData(NetName.GET_INFO).data;
            let endtime = new Date(window['endtime'] ? window['endtime'] : '2019-11-16 00:00:00').getTime();
            console.log('分享返回参数data:', data);

            PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL, 3);//写死的活动结束
            // if(data1.timestamp > endtime){
            //     //提示活动已结束
            //     PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL, 3);
            // }else{
            //     let issuccess:boolean;

            //     var u = navigator.userAgent;//, app = navigator.appVersion;
            //     var android = u.indexOf('Android') > -1 || u.indexOf('Linux') > -1; //g
            //     var iphone = !!u.match(/\(i[^;]+;( U;)? CPU.+Mac OS X/); //ios终端

            //     if(android){
            //         if(data == '0'){
            //             issuccess = true;
            //         }else{
            //             issuccess = false;
            //         }
            //     }

            //     if(iphone){

            //         if(data == '1'){
            //             issuccess = true;
            //         }else{
            //             issuccess = false;
            //         }
            //     }

            //     if(issuccess){
            //         //alert("分享成功");
            //         console.log("分享成功");
            //         NetManager.ins.shareData((success)=>{
            //             if(success){//加次数成功
            //                 PanelCtrl.instance.show(ModuleTypes.SHARE_SUC_PANEL);
            //             }else{
            //                 //加次数失败
            //                 TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'活动太火爆了，请稍后重试~'});
            //             }
            //         });
            //     }else{
            //         //alert("分享失败");
            //         console.log("分享失败");
    
            //         PanelCtrl.instance.show(ModuleTypes.GAMEOVER_PANEL, 0);
    
            //         // TopLayerCtrl.instance.show(ModuleTypes.TOAST_PANEL, {msg:'分享失败！'});
            //     }
            // }
            
        }
        window['ThirdApp'].webviewShare(param);
    }

    private onLoad(): void {
        if(this.type == 0){

            if(window['isapp']){
                let startDpmOut = Buried.connectDpm(110, 11, 1); // 点击埋点   
                let startDcmOut = Buried.connectDcm(202, 0, 0); // 曝光埋点
                let exposure = Buried.createExposure(startDpmOut, startDcmOut);
        
                NetManager.ins.showLog(exposure);
            }
        }else if(this.type == 1){

        }

        if(this.type == 1){
            this.shareBtn.visible = true;
            this.knowBtn.visible = false;
        }else{
            this.shareBtn.visible = false;
            this.knowBtn.visible = true;
        }

        for(let i = 0; i < 4; i++){
            if(this.type == i){
                this['text' + i].visible = true;
            }else{
                this['text' + i].visible = false;
            }
        }
    }


}