import { ModuleTypes } from "../types/sceneTypes";
import Scene from "../views/Scene";
import Loading from "../loading/Loading";
export default class SceneCtrl {
    private _parent: eui.UILayer;
    private _currentScene: Scene;

    static _instance: SceneCtrl;
    static get instance() {
        return SceneCtrl._instance || (SceneCtrl._instance = new SceneCtrl())
    }
    init(parent: eui.UILayer) {
        this._parent = parent;
    }

    change(type: ModuleTypes, data?) {
        if (this._currentScene) {
            let s = this._currentScene;
            egret.Tween.get(this._currentScene).to({alpha:0}, 800).call(()=>{
                s.destroy();
                this._parent.removeChild(s);

            })

            //为了修改切换显示场景时间
            setTimeout(() => {
                // Loading.instace.show();
                const cls = this._sceneClassMap[type];
                const scene: Scene = new cls(data);
                // scene.setSkinName();
                // scene.start();
                this.addToStage(scene);
            }, 1);

        }else{
            // Loading.instace.show();
            const cls = this._sceneClassMap[type];
            const scene: Scene = new cls(data);
            // scene.setSkinName();
            // scene.start();
            this.addToStage(scene);
        }
        
    }

    private addToStage(scene: Scene) {
        this._currentScene = scene;
        this._parent.addChild(scene);
    }

    private _sceneClassMap: any;
    registerSceneClass(name, definition) {
        this._sceneClassMap = this._sceneClassMap || {};
        this._sceneClassMap[name] = definition;
    }
}